/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.ui;

import java.io.IOException;
import java.io.OutputStream;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import org.richfaces.photoalbum.model.Image;
import org.richfaces.photoalbum.model.User;
import org.richfaces.photoalbum.ui.ImageLoader;
import org.richfaces.photoalbum.util.Preferred;

@Named
@RequestScoped
public class DirectLinkHelper {
    @Inject
    EntityManager em;
    @Inject
    ImageLoader imageLoader;
    @Inject
    @Preferred
    User user;

    public void paintImage(OutputStream out, Object data) throws IOException {
        Long id = Long.valueOf(data.toString());
        Image im = (Image)this.em.find(Image.class, (Object)id);
        if (this.isImageRecentlyRemoved(im)) {
            this.imageLoader.paintImage(out, (Object)"default/noimage_small200.jpg");
            return;
        }
        if (!this.isImageSharedOrBelongsToUser(im)) {
            return;
        }
        this.imageLoader.paintImage(out, (Object)im.getFullPath());
    }

    private boolean isImageSharedOrBelongsToUser(Image im) {
        return im.getAlbum() != null && (im.getAlbum().getShelf().isShared() || this.user != null && im.getAlbum().getOwner().getLogin().equals(this.user.getLogin()));
    }

    private boolean isImageRecentlyRemoved(Image im) {
        return im == null || im.getAlbum() == null || im.getAlbum().getShelf() == null;
    }
}

