/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.model.actions;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.richfaces.photoalbum.model.Album;
import org.richfaces.photoalbum.model.Shelf;
import org.richfaces.photoalbum.model.actions.IAlbumAction;
import org.richfaces.photoalbum.util.PhotoAlbumException;

@Stateless
public class AlbumAction
implements IAlbumAction {
    @Inject
    EntityManager em;

    public void addAlbum(Album album) throws PhotoAlbumException {
        try {
            this.em.persist((Object)album);
            album.getShelf().addAlbum(album);
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void deleteAlbum(Album album) throws PhotoAlbumException {
        Shelf parentShelf = (Shelf)this.em.find(Shelf.class, (Object)album.getShelf().getId());
        try {
            if (parentShelf == null) {
                return;
            }
            this.em.remove(this.em.merge((Object)album));
            parentShelf.removeAlbum(album);
            this.em.merge((Object)parentShelf);
            this.em.flush();
            album.setShelf(parentShelf);
        }
        catch (Exception e) {
            parentShelf.addAlbum(album);
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void editAlbum(Album album) throws PhotoAlbumException {
        try {
            this.em.merge((Object)album);
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public Album resetAlbum(Album album) {
        Album a = (Album)this.em.merge((Object)album);
        this.em.refresh((Object)a);
        return a;
    }
}

