/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.ui;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.SessionScoped;
import javax.inject.Named;
import org.richfaces.component.UITree;

@Named
@SessionScoped
public class TreeSelectionHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, UITree> treeMap = new HashMap();
    private static final String predefined = "PreDefinedTree";
    private static final String user = "userTree";
    private static final String event = "eventTree";
    private String lastTreeId = "";

    public TreeSelectionHelper() {
        this.treeMap.put(predefined, new UITree());
        this.treeMap.put(user, new UITree());
        this.treeMap.put(event, new UITree());
    }

    public UITree getPredefinedTree() {
        return (UITree)this.treeMap.get(predefined);
    }

    public void setPredefinedTree(UITree predefinedTree) {
        this.treeMap.put(predefined, predefinedTree);
    }

    public UITree getUserTree() {
        return (UITree)this.treeMap.get(user);
    }

    public void setUserTree(UITree userTree) {
        this.treeMap.put(user, userTree);
    }

    public UITree getEventTree() {
        return (UITree)this.treeMap.get(event);
    }

    public void setEventTree(UITree eventTree) {
        this.treeMap.put(event, eventTree);
    }

    public void unselectOtherTrees(String id) {
        if (this.lastTreeId.equals(id)) {
            return;
        }
        for (Map.Entry e : this.treeMap.entrySet()) {
            if (e.getValue() == null || ((String)e.getKey()).equals(id)) continue;
            ((UITree)e.getValue()).setSelection(null);
        }
        this.lastTreeId = id;
    }
}

