/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.OrderBy;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.richfaces.photoalbum.model.Album;
import org.richfaces.photoalbum.model.Comment;
import org.richfaces.photoalbum.model.MetaTag;
import org.richfaces.photoalbum.model.User;
import org.richfaces.photoalbum.util.DateUtils;

@NamedQueries(value={@NamedQuery(name="tag-byName", query="select m from MetaTag m where m.tag =:tag"), @NamedQuery(name="tag-popular", query="select new org.richfaces.photoalbum.model.MetaTag(m.id, m.tag) from MetaTag m join m.images img group by m.id, m.tag order by count(img) desc"), @NamedQuery(name="user-shelves", query="select distinct s from Shelf s where (s.shared = true and s.owner.preDefined = true and s.event = null) order by s.name"), @NamedQuery(name="image-exist", query="select i from Image i where i.path = :path and i.album = :album"), @NamedQuery(name="image-countIdenticalImages", query="select count(i) from Image i where i.path like :path and i.album = :album"), @NamedQuery(name="tag-suggest", query="select m from MetaTag m where lower(m.tag) like :tag")})
@Entity
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class Image
implements Serializable {
    private static final long serialVersionUID = -7042878411608396483L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonProperty
    private Long id;
    @ManyToMany
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @JsonProperty
    private List<MetaTag> imageTags = new ArrayList();
    @OrderBy(clause="date asc")
    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="image")
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<Comment> comments = new ArrayList();
    @NotNull
    @ManyToOne
    @JoinColumn
    private Album album;
    @NotNull
    @NotEmpty
    @Length(min=3, max=200)
    @Column(length=255, nullable=false)
    @JsonProperty
    private String name;
    @Transient
    private boolean covering;
    @NotNull
    @NotEmpty
    @Length(min=3)
    @Column(length=1024, nullable=false)
    private String path;
    @Column(length=255)
    @JsonProperty
    private String cameraModel;
    private int height;
    private double size;
    private int width;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date uploaded;
    @NotNull
    @NotEmpty
    @Length(min=3)
    @Column(length=1024)
    @JsonProperty
    private String description;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @NotNull
    private boolean allowComments;
    private Boolean showMetaInfo = true;
    @Transient
    private boolean visited;
    @Transient
    private String meta = "";

    public boolean isPreDefined() {
        return this.getAlbum().isPreDefined();
    }

    public Boolean getShowMetaInfo() {
        return this.showMetaInfo;
    }

    public void setShowMetaInfo(Boolean showMetaInfo) {
        this.showMetaInfo = showMetaInfo;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Album getAlbum() {
        return this.album;
    }

    public void setAlbum(Album album) {
        this.album = album;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public List<MetaTag> getImageTags() {
        return this.imageTags;
    }

    public void setMeta(String meta) {
        this.meta = meta;
    }

    public String getMetaString() {
        return this.meta;
    }

    public String getCameraModel() {
        return this.cameraModel;
    }

    public void setCameraModel(String cameraModel) {
        this.cameraModel = cameraModel;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Date getUploaded() {
        return this.uploaded;
    }

    public void setUploaded(Date uploaded) {
        this.uploaded = uploaded;
    }

    public boolean isAllowComments() {
        return this.allowComments;
    }

    public void setAllowComments(boolean allowComments) {
        this.allowComments = allowComments;
    }

    public boolean isCovering() {
        return this.covering;
    }

    public void setImageTags(List<MetaTag> imageTags) {
        this.imageTags = imageTags;
    }

    public void setCovering(boolean covering) {
        this.covering = covering;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public boolean isNew() {
        if (!this.visited) {
            return this.getUploaded().after(DateUtils.getRecentlyDate());
        }
        return false;
    }

    public void addComment(Comment comment) {
        if (comment == null) {
            throw new IllegalArgumentException("Null comment!");
        }
        comment.setImage(this);
        this.comments.add(comment);
    }

    public void removeComment(Comment comment) {
        if (comment == null) {
            throw new IllegalArgumentException("Null comment");
        }
        if (!comment.getImage().equals((Object)this)) {
            throw new IllegalArgumentException("Comment not belongs to this image");
        }
        this.comments.remove(comment);
    }

    public void addMetaTag(MetaTag metatag) {
        if (metatag == null) {
            throw new IllegalArgumentException("Null metatag!");
        }
        if (!this.imageTags.contains(metatag)) {
            metatag.addImage(this);
            this.imageTags.add(metatag);
        }
    }

    public void removeMetaTag(MetaTag metatag) {
        if (metatag == null) {
            throw new IllegalArgumentException("Null metatag!");
        }
        if (this.imageTags.contains(metatag)) {
            metatag.removeImage(this);
            this.imageTags.remove(metatag);
        }
    }

    public MetaTag getTagByName(String s) {
        for (MetaTag t : this.imageTags) {
            if (!t.getTag().equals(s)) continue;
            return t;
        }
        return null;
    }

    public String getMeta() {
        StringBuilder s = new StringBuilder();
        for (MetaTag tag : this.imageTags) {
            s.append(tag.getTag()).append(", ");
        }
        if (s.length() >= 2) {
            s.delete(s.length() - 2, s.length());
        }
        return s.toString();
    }

    public String getFullPath() {
        if (this.getAlbum().getPath() == null) {
            return null;
        }
        return this.getAlbum().getPath() + this.path;
    }

    public User getOwner() {
        return this.getAlbum().getOwner();
    }

    public boolean isOwner(User user) {
        return user != null && user.equals((Object)this.getOwner());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Image image = (Image)obj;
        return (this.id == null ? image.getId() == null : this.id.equals(image.getId())) && (this.path == null ? image.getPath() == null : this.path.equals(image.getPath()));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{id : " + this.getId() + ", name : " + this.getName() + "}";
    }
}

