/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Named;
import org.richfaces.photoalbum.model.Image;
import org.richfaces.photoalbum.model.event.EventType;
import org.richfaces.photoalbum.model.event.Events;
import org.richfaces.photoalbum.model.event.ImageEvent;
import org.richfaces.photoalbum.model.event.SimpleEvent;
import org.richfaces.photoalbum.ui.FileWrapper;

@Named
@ApplicationScoped
public class FileWrapper
implements Serializable {
    private static final long serialVersionUID = -1767281809514660171L;
    private boolean complete = false;
    private List<Image> files = new ArrayList();
    private List<ErrorImage> errorFiles = new ArrayList();

    public int getSize() {
        return this.getFiles().size();
    }

    public List<Image> getFiles() {
        return this.files;
    }

    public void setFiles(List<Image> files) {
        this.files = files;
    }

    public void removeImage(@Observes @EventType(value=Events.IMAGE_DRAGGED_EVENT) ImageEvent ie) {
        this.files.remove(ie.getImage());
    }

    public void clear(@Observes @EventType(value=Events.CLEAR_FILE_UPLOAD_EVENT) SimpleEvent se) {
        this.files.clear();
        this.errorFiles.clear();
        this.complete = false;
    }

    public void onFileUploadError(Image image, String error) {
        ErrorImage e = new ErrorImage(this, image, error);
        this.errorFiles.add(e);
    }

    public Image getErrorImage(ErrorImage e) {
        return e.getImage();
    }

    public String getErrorDescription(ErrorImage e) {
        return e.getErrorDescription();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public List<ErrorImage> getErrorFiles() {
        return this.errorFiles;
    }

    public void setErrorFiles(List<ErrorImage> errorFiles) {
        this.errorFiles = errorFiles;
    }
}

