/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.social.facebook;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.json.JSONArray;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONObject;
import org.richfaces.photoalbum.model.event.ErrorEvent;
import org.richfaces.photoalbum.model.event.EventType;
import org.richfaces.photoalbum.model.event.Events;

@Named
@ApplicationScoped
public class FacebookAlbumCache {
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    private Map<String, JSONObject> albums = new HashMap();
    private Map<String, Map<String, JSONObject>> images = new HashMap();
    private boolean needsUpdate = true;
    private String currentAlbumId;
    private String currentImageId;

    public void setAll(String json) {
        try {
            JSONObject jo = new JSONObject(json);
            if (!jo.has("albums")) {
                return;
            }
            this.storeAlbums(jo.getJSONArray("albums"), jo.getJSONArray("covers"));
            this.storeImagesToAlbum(jo.getJSONArray("images"));
            this.setNeedsUpdate(false);
        }
        catch (JSONException e) {
            this.error.fire((Object)new ErrorEvent("Error: ", e.getMessage()));
        }
    }

    public void setAlbums(String json) {
        try {
            JSONObject jo = new JSONObject(json);
            if (!jo.has("albums")) {
                return;
            }
            this.storeAlbums(jo.getJSONArray("albums"), jo.getJSONArray("covers"));
        }
        catch (JSONException e) {
            this.error.fire((Object)new ErrorEvent("Error: ", e.getMessage()));
        }
    }

    public void storeAlbums(JSONArray jAlbums, JSONArray jCovers) {
        this.storeAlbums(jAlbums, jCovers, false);
    }

    public void storeAlbums(JSONArray jAlbums, JSONArray jCovers, boolean rewrite) {
        int offset = 0;
        try {
            for (int i = 0; i < jAlbums.length(); ++i) {
                JSONObject jo = jAlbums.getJSONObject(i);
                JSONObject jc = jCovers.getJSONObject(i - offset);
                if (!jo.has("id")) {
                    this.error.fire((Object)new ErrorEvent("Error, object does not contain albums"));
                }
                String albumId = jo.getString("id");
                if (jc.getString("pid").equals(jo.getString("cpid"))) {
                    jo.put("coverUrl", (Object)jc.getString("coverUrl"));
                } else {
                    ++offset;
                    jo.put("coverUrl", (Object)"resources/img/shell/frame_photo_120.png");
                    jo.put("empty", true);
                }
                if (this.albums.containsKey(albumId) && !rewrite) {
                    return;
                }
                if (rewrite) {
                    this.albums.remove(albumId);
                }
                this.images.put(albumId, new HashMap());
                this.albums.put(albumId, jo);
            }
        }
        catch (JSONException je) {
            this.error.fire((Object)new ErrorEvent("Error", je.getMessage()));
        }
    }

    public void storeImagesToAlbum(JSONArray ja) {
        String imageId = "";
        String albumId = "";
        try {
            for (int i = 0; i < ja.length(); ++i) {
                JSONObject jo = ja.getJSONObject(i);
                if (!jo.has("albumId") || !jo.has("id")) {
                    this.error.fire((Object)new ErrorEvent("Error, object does not contain images"));
                }
                albumId = jo.getString("albumId");
                imageId = jo.getString("id");
                ((Map)this.images.get(albumId)).put(imageId, jo);
            }
        }
        catch (JSONException je) {
            this.error.fire((Object)new ErrorEvent("Error", je.getMessage()));
        }
    }

    public JSONObject getAlbum(String albumId) {
        return (JSONObject)this.albums.get(albumId);
    }

    public Map<String, JSONObject> getImageMap(String albumId) {
        return (Map)this.images.get(albumId);
    }

    public List<JSONObject> getImagesFromAlbum(String albumId) {
        return new ArrayList<JSONObject>(((Map)this.images.get(albumId)).values());
    }

    public List<JSONObject> getAlbums(List<String> albumIds) {
        if (albumIds == null) {
            return null;
        }
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (String id : albumIds) {
            list.add((JSONObject)this.albums.get(id));
        }
        return list;
    }

    public boolean isAlbumLoaded(String albumId) {
        return this.albums.get(albumId) != null && (((JSONObject)this.albums.get(albumId)).optBoolean("empty", false) || !((Map)this.images.get(albumId)).isEmpty());
    }

    public boolean areAlbumsLoaded(List<String> albumIds) {
        if (this.needsUpdate) {
            return false;
        }
        if (albumIds != null) {
            for (String id : albumIds) {
                if (this.isAlbumLoaded(id)) continue;
                this.setNeedsUpdate(true);
                return false;
            }
        }
        this.setNeedsUpdate(false);
        return true;
    }

    public boolean isNeedsUpdate() {
        return this.needsUpdate;
    }

    public void setNeedsUpdate(boolean needsUpdate) {
        this.needsUpdate = needsUpdate;
    }

    public String getCurrentAlbumId() {
        return this.currentAlbumId;
    }

    public void setCurrentAlbumId(String currentAlbumId) {
        this.currentAlbumId = currentAlbumId;
    }

    public String getCurrentImageId() {
        return this.currentImageId;
    }

    public void setCurrentImageId(String currentImageId) {
        this.currentImageId = currentImageId;
    }

    public JSONObject getCurrentAlbum() {
        return (JSONObject)this.albums.get(this.currentAlbumId);
    }

    public List<JSONObject> getCurrentImages() {
        return new ArrayList<JSONObject>(((Map)this.images.get(this.currentAlbumId)).values());
    }

    public JSONObject getCurrentImage() {
        return (JSONObject)((Map)this.images.get(this.currentAlbumId)).get(this.currentImageId);
    }
}

