/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.richfaces.photoalbum.util.FileManipulation;

@Startup
@ApplicationScoped
public class ImageCopier {
    @Produces
    private File uploadRoot;
    @Produces
    private String uploadRootPath;
    private String imageSrc;

    @PostConstruct
    public void create() throws IOException {
        this.resolveImageFolder();
        this.resolveUploadRoot();
        this.copyImages();
    }

    @PreDestroy
    public void destroy() throws IOException {
        FileManipulation.deleteDirectory((File)this.uploadRoot, (boolean)true);
    }

    private void resolveImageFolder() throws MalformedURLException {
        ServletContext servletContext = ((HttpSession)FacesContext.getCurrentInstance().getExternalContext().getSession(false)).getServletContext();
        if (servletContext == null) {
            throw new IllegalStateException("Cannot bound image folder path");
        }
        this.imageSrc = servletContext.getRealPath("WEB-INF/classes/Upload");
    }

    private void resolveUploadRoot() throws IOException {
        this.uploadRoot = new File(FileManipulation.joinFiles((String[])new String[]{System.getProperty("java.io.tmpdir"), "richfaces_photoalbum"}));
        if (this.uploadRoot.exists()) {
            FileManipulation.deleteDirectory((File)this.uploadRoot, (boolean)true);
        }
        this.uploadRoot.mkdir();
        this.uploadRootPath = this.uploadRoot.getCanonicalPath();
    }

    private void copyImages() {
        try {
            FileManipulation.copyDirectory((File)new File(this.imageSrc), (File)this.uploadRoot);
        }
        catch (IOException e) {
            System.out.println("ERROR on copy '" + this.imageSrc + "' to '" + this.uploadRoot + '\'');
        }
    }
}

