/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.richfaces.photoalbum.manager.Model;
import org.richfaces.photoalbum.model.Album;
import org.richfaces.photoalbum.model.Shelf;
import org.richfaces.photoalbum.model.User;
import org.richfaces.photoalbum.model.actions.IAlbumAction;
import org.richfaces.photoalbum.model.event.AlbumEvent;
import org.richfaces.photoalbum.model.event.ErrorEvent;
import org.richfaces.photoalbum.model.event.EventType;
import org.richfaces.photoalbum.model.event.EventTypeQualifier;
import org.richfaces.photoalbum.model.event.Events;
import org.richfaces.photoalbum.util.Preferred;

@Named
@RequestScoped
public class AlbumManager
implements Serializable {
    private static final long serialVersionUID = 2631634926126857691L;
    private boolean validationSuccess = false;
    private boolean errorInCreate = false;
    @Inject
    private IAlbumAction albumAction;
    @Inject
    @Preferred
    private User user;
    @Inject
    Model model;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    @Inject
    @Any
    Event<AlbumEvent> albumEvent;
    private Album album = new Album();

    public Album getAlbum() {
        return this.album;
    }

    public void setAlbum(Album album) {
        this.album = album;
    }

    public void addAlbum(Album album) {
        if (this.user == null) {
            return;
        }
        if (album.getShelf() == null) {
            FacesContext.getCurrentInstance().addMessage("shelf", new FacesMessage("", "album group name must not be null"));
            return;
        }
        if (this.user.hasAlbumWithName(album)) {
            this.error.fire((Object)new ErrorEvent("", "You already have an album with the given name in selected album group"));
            return;
        }
        this.validationSuccess = true;
        try {
            album.setCreated(new Date());
            this.albumAction.addAlbum(album);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while saving the album to the database<br/>" + e.getMessage()));
            return;
        }
        this.albumEvent.select(new Annotation[]{new EventTypeQualifier(Events.ALBUM_ADDED_EVENT)}).fire((Object)new AlbumEvent(album));
    }

    public void createAlbum(Shelf shelf, boolean isShowAlbumAfterCreate) {
        if (this.user == null) {
            return;
        }
        this.album = new Album();
        if (shelf == null) {
            if (this.model.getSelectedShelf() != null) {
                shelf = this.model.getSelectedShelf();
            } else if (this.user.getShelves().size() > 0) {
                shelf = (Shelf)this.user.getShelves().get(0);
            }
            if (shelf == null) {
                this.error.fire((Object)new ErrorEvent("", "You must create at least one album group before creating an album!"));
                this.setErrorInCreate(true);
                return;
            }
        }
        this.album.setShelf(shelf);
        this.album.setShowAfterCreate(isShowAlbumAfterCreate);
    }

    public void editAlbum(Album album, boolean editFromInplace) {
        if (this.user == null) {
            return;
        }
        try {
            Validator validator;
            Set constraintViolations;
            if (this.user.hasAlbumWithName(album)) {
                this.error.fire((Object)new ErrorEvent("", "You already have an album with the given name in selected album group"));
                this.albumAction.resetAlbum(album);
                return;
            }
            if (editFromInplace && (constraintViolations = (validator = Validation.buildDefaultValidatorFactory().getValidator()).validate((Object)album, new Class[0])).size() > 0) {
                for (ConstraintViolation cv : constraintViolations) {
                    this.error.fire((Object)new ErrorEvent("Constraint violation", cv.getMessage()));
                }
                this.albumAction.resetAlbum(album);
                return;
            }
            this.albumAction.editAlbum(album);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while saving the album to the database<br/>" + e.getMessage()));
            this.albumAction.resetAlbum(album);
            return;
        }
        this.albumEvent.select(new Annotation[]{new EventTypeQualifier(Events.ALBUM_EDITED_EVENT)}).fire((Object)new AlbumEvent(album));
    }

    public void deleteAlbum(Album album) {
        if (this.user == null) {
            return;
        }
        String pathToDelete = album.getPath();
        try {
            this.albumAction.deleteAlbum(album);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while deleting the album from the database.<br/>" + e.getMessage()));
            return;
        }
        this.albumEvent.select(new Annotation[]{new EventTypeQualifier(Events.ALBUM_DELETED_EVENT)}).fire((Object)new AlbumEvent(album, pathToDelete));
    }

    public boolean isValidationSuccess() {
        return this.validationSuccess;
    }

    public void setValidationSuccess(boolean validationSuccess) {
        this.validationSuccess = validationSuccess;
    }

    public boolean isErrorInCreate() {
        return this.errorInCreate;
    }

    public void setErrorInCreate(boolean errorInCreate) {
        this.errorInCreate = errorInCreate;
    }
}

