/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.richfaces.model.UploadedFile;
import org.richfaces.photoalbum.util.PhotoAlbumException;

public class FileHandler {
    private File file;
    private UploadedFile uFile;
    private boolean isStandardFile;

    public FileHandler(File file) {
        if (file != null) {
            this.file = file;
            this.isStandardFile = true;
        }
    }

    public FileHandler(UploadedFile uFile) {
        if (uFile != null) {
            this.uFile = uFile;
            this.isStandardFile = false;
        }
    }

    public InputStream getInputStream() throws FileNotFoundException, IOException {
        return this.isStandardFile ? new FileInputStream(this.file) : this.uFile.getInputStream();
    }

    public String getName() {
        return this.isStandardFile ? this.file.getName() : this.uFile.getName();
    }

    public long getSize() {
        return this.isStandardFile ? this.file.length() : this.uFile.getSize();
    }

    public void delete() throws Exception {
        if (this.isStandardFile) {
            if (!this.file.delete()) {
                throw new PhotoAlbumException("Error occurred during deleting the image from the disk");
            }
            return;
        }
        this.uFile.delete();
    }
}

