/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.photoalbum.manager.FileManager;

@Named
@RequestScoped
public class ImageLoader
implements Serializable {
    private static final long serialVersionUID = -1572789608594870285L;
    @Inject
    FileManager fileManager;

    public void paintImage(OutputStream out, Object data) throws IOException {
        if (null == data) {
            return;
        }
        File imageResource = this.fileManager.getFileByPath(data.toString());
        this.paintImageToBrowser(out, imageResource);
    }

    public void paintAvatarImage(OutputStream out, Object data) throws IOException {
        if (null == data) {
            return;
        }
        File imageResource = this.fileManager.getFileByPath(data.toString());
        if (imageResource == null || !imageResource.exists()) {
            imageResource = this.fileManager.getFileByAbsolutePath(data.toString());
        }
        this.paintImageToBrowser(out, imageResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintImageToBrowser(OutputStream out, File imageResource) throws IOException {
        if (imageResource != null && imageResource.exists()) {
            byte[] toWrite = new byte[8192];
            FileInputStream in = new FileInputStream(imageResource);
            try {
                while (in.read(toWrite) != -1) {
                    out.write(toWrite);
                }
            }
            finally {
                in.close();
            }
        } else {
            String suffix = this.excludeFilePrefix(imageResource.getPath());
            this.paintImage(out, (Object)this.fileManager.transformPath("default/noimage.jpg", suffix));
            return;
        }
    }

    private String excludeFilePrefix(String path) {
        int begin = path.lastIndexOf("_");
        int end = path.lastIndexOf(".");
        return path.substring(begin, end);
    }
}

