/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.ui;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.richfaces.photoalbum.util.ApplicationUtils;

@RequestScoped
public class UserExpiredPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private PhaseId phase = PhaseId.RESTORE_VIEW;

    public void beforePhase(PhaseEvent e) {
        ApplicationUtils utils = this.getUtils();
        utils.fireCheckUserExpiredEvent();
    }

    public void afterPhase(PhaseEvent e) {
    }

    public void setPhase(PhaseId phase) {
        this.phase = phase;
    }

    public PhaseId getPhaseId() {
        return this.phase;
    }

    public BeanManager getBeanManager() {
        BeanManager beanManager = null;
        try {
            InitialContext initialContext = new InitialContext();
            beanManager = (BeanManager)initialContext.lookup("java:comp/BeanManager");
        }
        catch (NamingException e) {
            Logger.getLogger("UserPhaseExpired").log(Level.SEVERE, "Couldn't get BeanManager through JNDI", e);
        }
        return beanManager;
    }

    private ApplicationUtils getUtils() {
        BeanManager bm = this.getBeanManager();
        Bean bean = (Bean)bm.getBeans(ApplicationUtils.class, new Annotation[0]).iterator().next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        ApplicationUtils utils = (ApplicationUtils)bm.getReference(bean, ApplicationUtils.class, ctx);
        return utils;
    }
}

