/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.bean;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.event.ErrorEvent;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.util.Preferred;

@Named
@ApplicationScoped
public class UserBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    EntityManager em;
    private User user;
    private String username;
    private String fbPhotoUrl;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> event;
    private String password;
    private boolean logged = false;
    private boolean loggedInFB = false;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public User logIn(String username, String passwordHash) throws Exception {
        this.user = (User)this.em.createNamedQuery("user-login").setParameter("username", (Object)username).setParameter("password", (Object)passwordHash).getSingleResult();
        this.logged = this.user != null;
        return this.user;
    }

    public User logIn(String facebookId) {
        List users = this.em.createNamedQuery("user-fb-login").setParameter("fbId", (Object)facebookId).getResultList();
        if (users.isEmpty()) {
            this.logged = false;
            this.loggedInFB = false;
            return null;
        }
        this.user = (User)users.get(0);
        this.logged = true;
        this.loggedInFB = true;
        return this.user;
    }

    @Produces
    @Preferred
    public User getUser() {
        if (!this.logged) {
            return null;
        }
        return this.user;
    }

    public void refreshUser() {
        if (this.logged) {
            this.user = (User)this.em.createNamedQuery("user-login").setParameter("username", (Object)this.user.getLogin()).setParameter("password", (Object)this.user.getPasswordHash()).getSingleResult();
            this.logged = this.user != null;
        }
    }

    public boolean isLoggedIn() {
        return this.logged;
    }

    public boolean isLoggedInFB() {
        return this.loggedInFB;
    }

    public void logout() {
        this.user = null;
        this.logged = false;
        this.loggedInFB = false;
        this.fbPhotoUrl = "";
    }

    public void reset() {
        this.username = "";
        this.password = "";
    }

    public String getFbPhotoUrl() {
        return this.fbPhotoUrl;
    }

    public void setFbPhotoUrl(String fbPhotoUrl) {
        this.fbPhotoUrl = fbPhotoUrl;
    }
}

