/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.domain;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.OrderBy;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.richfaces.photoalbum.domain.Album;
import org.richfaces.photoalbum.domain.Image;
import org.richfaces.photoalbum.domain.Sex;
import org.richfaces.photoalbum.domain.Shelf;

@NamedQueries(value={@NamedQuery(name="user-login", query="select u from User u where u.login = :username and u.passwordHash = :password"), @NamedQuery(name="user-comments", query="select c from Comment c where c.author = :author"), @NamedQuery(name="user-exist", query="select u from User u where u.login = :login"), @NamedQuery(name="email-exist", query="select u from User u where u.email = :email"), @NamedQuery(name="user-user", query="select u from User u where u.login = :login"), @NamedQuery(name="user-fb-login", query="select u from User u where u.fbId = :fbId")})
@Entity
@SessionScoped
@Table(name="User", uniqueConstraints={@UniqueConstraint(columnNames={"login"}), @UniqueConstraint(columnNames={"email"})})
public class User
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @NotEmpty
    @Column(length=20)
    private String fbId;
    @NotNull
    private String passwordHash;
    @NotNull
    @NotEmpty
    @Length(min=3)
    @Column(length=255, nullable=false)
    private String firstName;
    @NotNull
    @NotEmpty
    @Length(min=3)
    @Column(length=255, nullable=false)
    private String secondName;
    @Column(length=255, nullable=false)
    @NotNull
    @NotEmpty
    @Email
    private String email;
    @Column(length=255, nullable=false)
    @NotNull
    @NotEmpty
    @Length(min=3)
    private String login;
    @Transient
    private String password;
    @Transient
    private String confirmPassword;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date birthDate;
    @NotNull
    private Sex sex = Sex.MALE;
    private Boolean hasAvatar;
    @OrderBy(clause="NAME asc")
    @OneToMany(mappedBy="owner", cascade={CascadeType.ALL})
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<Shelf> shelves = new ArrayList();
    private boolean preDefined;

    public boolean isPreDefined() {
        return this.preDefined;
    }

    public void setPreDefined(boolean preDefined) {
        this.preDefined = preDefined;
    }

    public String getFbId() {
        return this.fbId;
    }

    public void setFbId(String fbId) {
        this.fbId = fbId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getSecondName() {
        return this.secondName;
    }

    public void setSecondName(String secondName) {
        this.secondName = secondName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    public Long getId() {
        return this.id;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public List<Shelf> getShelves() {
        ArrayList<Shelf> shelvesWithoutEvents = new ArrayList<Shelf>();
        for (Shelf shelf : this.shelves) {
            if (shelf.getEvent() != null) continue;
            shelvesWithoutEvents.add(shelf);
        }
        return shelvesWithoutEvents;
    }

    public Sex getSex() {
        return this.sex;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    public Boolean getHasAvatar() {
        return this.hasAvatar;
    }

    public void setHasAvatar(Boolean hasAvatar) {
        this.hasAvatar = hasAvatar;
    }

    public void addShelf(Shelf shelf) {
        if (shelf == null) {
            throw new IllegalArgumentException("Null shelf!");
        }
        if (!this.shelves.contains(shelf)) {
            shelf.setOwner(this);
            this.shelves.add(shelf);
        }
    }

    public void removeShelf(Shelf shelf) {
        if (shelf == null) {
            throw new IllegalArgumentException("Null shelf");
        }
        if (!shelf.getOwner().getLogin().equals(this.getLogin())) {
            throw new IllegalArgumentException("Shelf not belongs to this user!");
        }
        shelf.setOwner(null);
        this.shelves.remove(shelf);
    }

    public String getPath() {
        if (this.getId() == null) {
            return null;
        }
        return File.separator + this.getLogin() + File.separator;
    }

    public List<Image> getImages() {
        ArrayList<Image> images = new ArrayList<Image>();
        for (Shelf s : this.getShelves()) {
            images.addAll(s.getImages());
        }
        return images;
    }

    public List<Album> getAlbums() {
        ArrayList<Album> albums = new ArrayList<Album>();
        for (Shelf s : this.getShelves()) {
            albums.addAll(s.getAlbums());
        }
        return albums;
    }

    public List<Image> getSharedImages() {
        ArrayList<Image> images = new ArrayList<Image>();
        for (Shelf s : this.getShelves()) {
            if (!s.isShared()) continue;
            for (Album a : s.getAlbums()) {
                images.addAll(a.getImages());
            }
        }
        return images;
    }

    public List<Album> getSharedAlbums() {
        ArrayList<Album> albums = new ArrayList<Album>();
        for (Shelf s : this.getShelves()) {
            if (!s.isShared()) continue;
            albums.addAll(s.getAlbums());
        }
        return albums;
    }

    public boolean hasShelfWithName(Shelf shelf) {
        for (Shelf s : this.getShelves()) {
            if (s.equals((Object)shelf) || !s.getName().equals(shelf.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasAlbumWithName(Album album) {
        for (Album a : album.getShelf().getAlbums()) {
            if (a.equals((Object)album) || !a.getName().equals(album.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasImageWithName(Image image) {
        for (Image i : image.getAlbum().getImages()) {
            if (i.equals((Object)image) || !i.getName().equals(image.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        if (this.id != null ? !this.id.equals(user.id) : user.id != null) {
            return false;
        }
        return !(this.login != null ? !this.login.equals(user.login) : user.login != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.login != null ? this.login.hashCode() : 0);
        return result;
    }
}

