/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.json.JSONObject;
import org.richfaces.photoalbum.bean.UserBean;
import org.richfaces.photoalbum.domain.Sex;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.EventTypeQualifier;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.NavEvent;
import org.richfaces.photoalbum.event.SimpleEvent;
import org.richfaces.photoalbum.manager.FileManager;
import org.richfaces.photoalbum.manager.LoggedUserTracker;
import org.richfaces.photoalbum.manager.NavigationEnum;
import org.richfaces.photoalbum.service.IUserAction;
import org.richfaces.photoalbum.social.FacebookBean;
import org.richfaces.photoalbum.util.Environment;
import org.richfaces.photoalbum.util.HashUtils;
import org.richfaces.photoalbum.util.Utils;

@Named
@ApplicationScoped
public class Authenticator
implements Serializable {
    private static final long serialVersionUID = -4585673256547342140L;
    @Inject
    LoggedUserTracker userTracker;
    @Inject
    IUserAction userAction;
    private User user;
    private boolean loginFailed = false;
    private boolean conversationStarted = false;
    @Inject
    @Any
    Event<SimpleEvent> event;
    @Inject
    @EventType(value=Events.UPDATE_MAIN_AREA_EVENT)
    Event<NavEvent> navEvent;
    @Inject
    FileManager fileManager;
    @Inject
    UserBean userBean;
    @Inject
    FacebookBean fBean;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean authenticate() {
        try {
            this.user = this.userBean.logIn(this.userBean.getUsername(), HashUtils.hash((String)this.userBean.getPassword()));
            if (this.user != null) {
                if (Environment.isInProduction() && this.user.isPreDefined()) {
                    this.loginFailed();
                    this.user = new User();
                    return false;
                }
                this.addToTracker(this.user.getId());
                this.event.select(new Annotation[]{new EventTypeQualifier(Events.AUTHENTICATED_EVENT)}).fire((Object)new SimpleEvent());
                this.setLoginFailed(false);
                return true;
            }
        }
        catch (Exception nre) {
            this.loginFailed();
            return false;
        }
        return false;
    }

    private void addToTracker(Long userId) {
        this.userTracker.removeUserId(userId);
        this.userTracker.addUserId(userId, Utils.getSession().getId());
    }

    public boolean authenticateWithFacebook() {
        JSONObject userInfo = this.fBean.getUserInfo();
        try {
            String pictureUrl = userInfo.getJSONObject("picture").getJSONObject("data").getString("url");
            this.userBean.setFbPhotoUrl(pictureUrl);
            String facebookId = userInfo.getString("id");
            this.user = this.userBean.logIn(facebookId);
            if (this.user == null) {
                User newUser = new User();
                newUser.setFbId(facebookId);
                newUser.setFirstName(userInfo.getString("first_name"));
                newUser.setSecondName(userInfo.getString("last_name"));
                newUser.setEmail(userInfo.getString("email"));
                String username = userInfo.has("username") ? userInfo.getString("username") : userInfo.getString("first_name");
                newUser.setLogin(username);
                String sex = userInfo.getString("gender");
                newUser.setSex(sex.equals("male") ? Sex.MALE : Sex.FEMALE);
                SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
                newUser.setBirthDate(sdf.parse(userInfo.getString("birthday")));
                newUser.setPasswordHash(HashUtils.hash((String)"facebook"));
                this.userAction.register(newUser);
                this.userBean.logIn(facebookId);
            } else {
                this.addToTracker(this.user.getId());
            }
            return true;
        }
        catch (Exception nre) {
            this.loginFailed();
            return false;
        }
    }

    public void logout() {
        long id = this.userBean.getUser().getId();
        this.userBean.logout();
        this.user = null;
        this.userTracker.removeUserId(Long.valueOf(id));
        this.setConversationStarted(false);
        this.startConversation();
    }

    public void register(User user) {
        if (this.checkPassword(user) || this.checkUserExist(user) || this.checkEmailExist(user.getEmail())) {
            return;
        }
        user.setPasswordHash(HashUtils.hash((String)user.getPassword()));
        user.setPreDefined(false);
        if (!this.handleAvatar(user)) {
            return;
        }
        try {
            this.userAction.register(user);
        }
        catch (Exception e) {
            this.event.select(new Annotation[]{new EventTypeQualifier(Events.ADD_ERROR_EVENT)}).fire((Object)new SimpleEvent("Error while registration process"));
            return;
        }
        try {
            this.user = this.userBean.logIn(user.getLogin(), HashUtils.hash((String)user.getPassword()));
        }
        catch (Exception e) {
            this.event.select(new Annotation[]{new EventTypeQualifier(Events.ADD_ERROR_EVENT)}).fire((Object)new SimpleEvent("Login error\n" + e.getMessage()));
            return;
        }
        if (this.user == null) {
            this.event.select(new Annotation[]{new EventTypeQualifier(Events.ADD_ERROR_EVENT)}).fire((Object)new SimpleEvent("Login error"));
        }
    }

    public void goToRegister() {
        this.user = new User();
        this.setLoginFailed(false);
        this.event.select(new Annotation[]{new EventTypeQualifier(Events.START_REGISTER_EVENT)}).fire((Object)new SimpleEvent());
    }

    @PostConstruct
    public String startConversation() {
        this.navEvent.fire((Object)new NavEvent(NavigationEnum.ANONYM));
        this.setConversationStarted(true);
        return "";
    }

    private boolean handleAvatar(User user) {
        File avatarData = null;
        if (avatarData != null) {
            user.setHasAvatar(Boolean.valueOf(true));
            if (this.fileManager == null || !this.fileManager.saveAvatar(avatarData, user)) {
                this.event.select(new Annotation[]{new EventTypeQualifier(Events.ADD_ERROR_EVENT)}).fire((Object)new SimpleEvent("An error occurred while saving the avatar to the disk"));
                return false;
            }
        }
        return true;
    }

    private boolean checkUserExist(User user) {
        if (this.userAction.isUserExist(user.getLogin())) {
            Utils.addFacesMessage((String)"overForm:userLoginName", (String)"", (String)"A user with this login already exists");
            return true;
        }
        return false;
    }

    private boolean checkEmailExist(String email) {
        if (this.userAction.isEmailExist(email)) {
            Utils.addFacesMessage((String)"overForm:userEmail", (String)"", (String)"E-mail is not unique");
            return true;
        }
        return false;
    }

    private boolean checkPassword(User user) {
        if (!user.getPassword().equals(user.getConfirmPassword())) {
            Utils.addFacesMessage((String)"overForm:userConfirmPassword", (String)"", (String)"Confirm Password not equals password");
            return true;
        }
        return false;
    }

    private void loginFailed() {
        this.setLoginFailed(true);
        Utils.addFacesMessage((String)"overForm:loginPanel", (String)"", (String)"Invalid login or password");
        FacesContext.getCurrentInstance().renderResponse();
    }

    public boolean isLoginFailed() {
        return this.loginFailed;
    }

    public void setLoginFailed(boolean loginFailed) {
        this.loginFailed = loginFailed;
    }

    public boolean isConversationStarted() {
        return this.conversationStarted;
    }

    public void setConversationStarted(boolean conversationStarted) {
        this.conversationStarted = conversationStarted;
    }
}

