/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Event;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONObject;
import org.richfaces.photoalbum.domain.Album;
import org.richfaces.photoalbum.event.ErrorEvent;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.ShelfEvent;
import org.richfaces.photoalbum.manager.AlbumManager;
import org.richfaces.photoalbum.manager.EventManager;
import org.richfaces.photoalbum.manager.FileUploadManager;
import org.richfaces.photoalbum.manager.Model;
import org.richfaces.photoalbum.service.IAlbumAction;
import org.richfaces.photoalbum.service.IEventAction;
import org.richfaces.photoalbum.service.PhotoAlbumException;
import org.richfaces.photoalbum.util.FileHandler;

@Named
@SessionScoped
public class FileDownloadManager
implements Serializable {
    private static final long serialVersionUID = 3815919720565571122L;
    @Inject
    FileUploadManager fileUploadManager;
    @Inject
    AlbumManager albumManager;
    @Inject
    IAlbumAction albumAction;
    @Inject
    IEventAction eventAction;
    @Inject
    EventManager eventManager;
    @Inject
    Model model;
    @Inject
    @EventType(value=Events.EVENT_EDITED_EVENT)
    Event<ShelfEvent> shelfEvent;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    private List<String> imageUrls;
    private Iterator<String> iterator;
    private String pBarText;
    private int pBarValue = -1;
    private int size;
    private int count;
    private Album album;
    private String albumId;

    private void setImages(Map<String, JSONObject> images) throws JSONException {
        this.imageUrls = new ArrayList();
        for (JSONObject jo : images.values()) {
            if (jo.has("src_big")) {
                this.imageUrls.add(jo.getString("src_big"));
                continue;
            }
            this.imageUrls.add(jo.getString("src"));
        }
    }

    private void createAlbum(String name, org.richfaces.photoalbum.domain.Event event) {
        this.album = new Album();
        this.album.setName(name);
        this.album.setShelf(event.getShelf());
        this.albumManager.addAlbum(this.album);
    }

    public void setUpDownload(String albumName, String albumId, Map<String, JSONObject> images, org.richfaces.photoalbum.domain.Event event) {
        try {
            this.setImages(images);
        }
        catch (JSONException je) {
            this.error.fire((Object)new ErrorEvent("Error", "error saving album<br/>" + je.getMessage()));
        }
        this.size = this.imageUrls.size();
        this.count = 0;
        this.iterator = this.imageUrls.iterator();
        this.pBarText = "0 / " + this.size;
        this.pBarValue = 0;
        this.albumId = albumId;
        this.createAlbum(albumName, event);
        this.album = this.albumAction.resetAlbum(this.album);
    }

    public void downloadNext() {
        if (!this.hasNext()) {
            return;
        }
        String imageUrl = (String)this.iterator.next();
        this.uploadImage(imageUrl, this.album.getName() + imageUrl.substring(imageUrl.lastIndexOf(".")), this.album);
        ++this.count;
        this.pBarValue = this.count * 100 / this.size;
        this.pBarText = this.count + " / " + this.size;
    }

    public void finishDownload() {
        org.richfaces.photoalbum.domain.Event event = this.album.getShelf().getEvent();
        try {
            this.albumAction.editAlbum(this.album);
            this.album = this.albumAction.resetAlbum(this.album);
        }
        catch (PhotoAlbumException pae) {
            this.error.fire((Object)new ErrorEvent("Error", "error saving album<br/>" + pae.getMessage()));
        }
        if (event.getFacebookAlbums().contains(this.albumId)) {
            event.getFacebookAlbums().remove(this.albumId);
        }
        try {
            this.eventAction.editEvent(event);
        }
        catch (PhotoAlbumException pae) {
            this.error.fire((Object)new ErrorEvent("Error", "error removing album<br/>" + pae.getMessage()));
        }
        this.pBarText = "";
        this.pBarValue = -1;
        UIViewRoot root = FacesContext.getCurrentInstance().getViewRoot();
        UIComponent component = root.findComponent("overForm");
        FacesContext.getCurrentInstance().addMessage(component.getClientId(FacesContext.getCurrentInstance()), new FacesMessage(FacesMessage.SEVERITY_INFO, "Success!", "Album has been successfully imported"));
        this.shelfEvent.fire((Object)new ShelfEvent(event));
    }

    private void uploadImage(String imageUrl, String imageName, Album album) {
        File file = new File(imageName);
        try {
            int i;
            URL url = new URL(imageUrl);
            URLConnection con = url.openConnection();
            BufferedInputStream bis = new BufferedInputStream(con.getInputStream());
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file.getName()));
            while ((i = bis.read()) != -1) {
                bos.write(i);
            }
            bos.flush();
            bis.close();
        }
        catch (MalformedInputException malformedInputException) {
            this.error.fire((Object)new ErrorEvent("Error", "error uploading image<br/>" + malformedInputException.getMessage()));
        }
        catch (IOException ioException) {
            this.error.fire((Object)new ErrorEvent("Error", "IO error<br/>" + ioException.getMessage()));
        }
        this.fileUploadManager.uploadFile(new FileHandler(file), album);
    }

    public int getValue() {
        return this.pBarValue;
    }

    public String getText() {
        return this.pBarText;
    }

    public Iterator<String> getIterator() {
        return this.iterator;
    }

    public boolean hasNext() {
        return this.iterator != null && this.iterator.hasNext();
    }
}

