/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.jpeg.JpegDirectory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.model.UploadedFile;
import org.richfaces.photoalbum.domain.Album;
import org.richfaces.photoalbum.domain.Image;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.event.ErrorEvent;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.ImageEvent;
import org.richfaces.photoalbum.manager.FileManager;
import org.richfaces.photoalbum.manager.Model;
import org.richfaces.photoalbum.service.IImageAction;
import org.richfaces.photoalbum.service.PhotoAlbumException;
import org.richfaces.photoalbum.ui.FileWrapper;
import org.richfaces.photoalbum.util.FileHandler;
import org.richfaces.photoalbum.util.Preferred;
import org.richfaces.ui.input.fileUpload.FileUploadEvent;

@Named
@RequestScoped
public class FileUploadManager
implements Serializable {
    private static final long serialVersionUID = 4969087557225414955L;
    @Inject
    IImageAction imageAction;
    @Inject
    FileWrapper fileWrapper;
    @Inject
    Model model;
    @Inject
    @Preferred
    User user;
    @Inject
    private FileManager fileManager;
    @Inject
    @EventType(value=Events.IMAGE_ADDED_EVENT)
    Event<ImageEvent> imageEvent;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    Logger log = Logger.getLogger("FUManager");

    public void listener(FileUploadEvent event) {
        if (this.user == null) {
            return;
        }
        UploadedFile file = event.getUploadedFile();
        this.uploadFile(new FileHandler(file), this.model.getSelectedAlbum());
    }

    public void uploadFile(FileHandler fileHandler, Album album) {
        Image image = this.constructImage(fileHandler);
        try {
            this.extractMetadata(fileHandler, image);
        }
        catch (Exception e1) {
            this.addError(fileHandler, image, "Error processing occurred during the upload");
            return;
        }
        image.setAlbum(album);
        if (image.getAlbum() == null) {
            this.addError(fileHandler, image, "Please, specify the album to be downloaded");
            return;
        }
        try {
            if (this.imageAction.isImageWithThisPathExist(image.getAlbum(), image.getPath())) {
                String newPath = this.generateNewPath(image);
                image.setPath(newPath);
                image.setName(newPath);
            }
            this.imageAction.addImage(image);
        }
        catch (Exception e) {
            this.addError(fileHandler, image, " An error occurred while saving the image to the database.");
            return;
        }
        try {
            if (!this.fileManager.addImage(image.getFullPath(), fileHandler)) {
                this.addError(fileHandler, image, "Error occurred during saving the image to the disk");
                return;
            }
        }
        catch (IOException ioe) {
            this.log.log(Level.INFO, "error", ioe);
            this.addError(image, "Error occurred during saving the image to the disk - " + ioe.getMessage());
        }
        this.fileWrapper.setComplete(false);
        this.fileWrapper.getFiles().add(image);
        this.imageEvent.fire((Object)new ImageEvent(image));
        try {
            fileHandler.delete();
        }
        catch (IOException ioe) {
            this.log.log(Level.INFO, "error", ioe);
            this.addError(image, "Error deleting file - " + ioe.getMessage());
        }
    }

    private String generateNewPath(Image image) throws PhotoAlbumException {
        String path = image.getPath().substring(0, image.getPath().lastIndexOf("."));
        Long countCopies = this.imageAction.getCountIdenticalImages(image.getAlbum(), path) + 1L;
        String newPath = this.fileManager.transformPath(image.getPath(), "_" + countCopies);
        return newPath;
    }

    private void addError(FileHandler fileHandler, Image image, String error) {
        this.addError(image, error);
        try {
            fileHandler.delete();
        }
        catch (IOException e) {
            this.addError(image, e.getMessage());
        }
    }

    private void addError(Image image, String error) {
        String imageName = image != null ? image.getName() : "";
        this.error.fire((Object)new ErrorEvent("(" + imageName + ") " + error));
    }

    private Image constructImage(FileHandler fileHandler) {
        long size = fileHandler.getSize();
        String name = fileHandler.getName();
        Image image = new Image();
        image.setUploaded(new Date());
        image.setDescription(name);
        image.setName(name);
        image.setSize((double)size);
        image.setPath(name);
        image.setAllowComments(true);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractMetadata(FileHandler fileHandler, Image image) {
        InputStream in = null;
        try {
            in = fileHandler.getInputStream();
            Metadata metadata = JpegMetadataReader.readMetadata((InputStream)in);
            Directory exifDirectory = metadata.getDirectory(ExifIFD0Directory.class);
            Directory jpgDirectory = metadata.getDirectory(JpegDirectory.class);
            if (exifDirectory != null) {
                this.setupCameraModel(image, exifDirectory);
                this.setupCreatedDate(image, exifDirectory);
                if (jpgDirectory != null) {
                    this.setupDimensions(image, exifDirectory, jpgDirectory);
                }
            }
        }
        catch (Exception e) {
            this.addError(fileHandler, image, " An error occurred while saving the image to the database.");
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                this.addError(fileHandler, image, " An error occurred while saving the image to the database. - " + e.getMessage());
            }
        }
    }

    private void setupCreatedDate(Image image, Directory exifDirectory) throws MetadataException {
        if (exifDirectory.containsTag(36867)) {
            Date time = exifDirectory.getDate(36867);
            image.setCreated(time);
        }
    }

    private void setupDimensions(Image image, Directory exifDirectory, Directory jpgDirectory) {
        try {
            if (exifDirectory.containsTag(40962) && exifDirectory.containsTag(40963)) {
                int width = exifDirectory.getInt(40962);
                image.setWidth(width);
                int height = exifDirectory.getInt(40963);
                image.setHeight(height);
            } else if (jpgDirectory.containsTag(1)) {
                int width = jpgDirectory.getInt(3);
                image.setWidth(width);
                int height = jpgDirectory.getInt(1);
                image.setHeight(height);
            }
        }
        catch (MetadataException e) {
            this.addError(image, " An error occurred while saving the image to the database.");
        }
    }

    private void setupCameraModel(Image image, Directory exifDirectory) {
        if (exifDirectory.containsTag(272)) {
            String cameraModel = exifDirectory.getString(272);
            image.setCameraModel(cameraModel);
        } else {
            image.setCameraModel("");
        }
    }
}

