/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.io.File;
import java.io.Serializable;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.event.AlbumEvent;
import org.richfaces.photoalbum.event.ErrorEvent;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.SimpleEvent;
import org.richfaces.photoalbum.manager.FileManager;
import org.richfaces.photoalbum.service.IUserAction;

@RequestScoped
public class UserManager
implements Serializable {
    private static final long serialVersionUID = 6027103521084558931L;
    @Inject
    User user;
    @Inject
    FileManager fileManager;
    @Inject
    File avatarData;
    @Inject
    IUserAction userAction;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;

    public void editUser(@Observes @EventType(value=Events.EDIT_USER_EVENT) SimpleEvent se) {
        if (this.avatarData != null) {
            if (!this.fileManager.saveAvatar(this.avatarData, this.user)) {
                this.error.fire((Object)new ErrorEvent("File IO Error"));
                return;
            }
            this.avatarData.delete();
            this.avatarData = null;
            this.user.setHasAvatar(Boolean.valueOf(true));
        }
        try {
            this.user.setPreDefined(false);
            this.user = this.userAction.updateUser();
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while saving preferences to the database. <br/>" + e.getMessage()));
            return;
        }
    }

    public void onAlbumAdded(@Observes @EventType(value=Events.ALBUM_ADDED_EVENT) AlbumEvent ae) {
        this.user = this.userAction.refreshUser();
    }

    public void cancelEditUser(@Observes @EventType(value=Events.CANCEL_EDIT_USER_EVENT) SimpleEvent se) {
        this.avatarData = null;
    }
}

