/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.rest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.richfaces.photoalbum.domain.Event;
import org.richfaces.photoalbum.manager.EventManager;
import org.richfaces.photoalbum.service.IEventAction;

@Path(value="/events")
@RequestScoped
public class EventRESTService {
    @Inject
    IEventAction ea;
    @Inject
    EventManager evm;
    @Inject
    private Validator validator;

    @GET
    @Path(value="/all")
    @Produces(value={"application/json"})
    public List<Event> getAllEvents() {
        return this.evm.getAllEvents();
    }

    @GET
    @Path(value="/{id:[0-9][0-9]*}")
    @Produces(value={"application/json"})
    public Event lookupEventById(@PathParam(value="id") long id) {
        Event event = this.evm.getEventById(id);
        if (event == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return event;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createEvent(Event event) {
        Response.ResponseBuilder builder = null;
        try {
            this.validateEvent(event);
            this.ea.addEvent(event);
            builder = Response.ok();
        }
        catch (ConstraintViolationException ce) {
            builder = this.createViolationResponse(ce.getConstraintViolations());
        }
        catch (ValidationException e) {
            HashMap<String, String> responseObj = new HashMap<String, String>();
            responseObj.put("name", "Name taken");
            builder = Response.status((Response.Status)Response.Status.CONFLICT).entity(responseObj);
        }
        catch (Exception e) {
            HashMap<String, String> responseObj = new HashMap<String, String>();
            responseObj.put("error", e.getMessage());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(responseObj);
        }
        return builder.build();
    }

    private void validateEvent(Event event) throws ConstraintViolationException, ValidationException {
        Set violations = this.validator.validate((Object)event, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(new HashSet(violations));
        }
        if (this.nameAlreadyExists(event.getName())) {
            throw new ValidationException("Unique Name Violation");
        }
    }

    public boolean nameAlreadyExists(String name) {
        return this.ea.getEventByName(name) != null;
    }

    private Response.ResponseBuilder createViolationResponse(Set<ConstraintViolation<?>> violations) {
        HashMap<String, String> responseObj = new HashMap<String, String>();
        for (ConstraintViolation<?> violation : violations) {
            responseObj.put(violation.getPropertyPath().toString(), violation.getMessage());
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(responseObj);
    }
}

