/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.photoalbum.ejbsearch.ISearchAction;
import org.richfaces.photoalbum.event.ErrorEvent;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.NavEvent;
import org.richfaces.photoalbum.manager.NavigationEnum;
import org.richfaces.photoalbum.search.ISearchOption;
import org.richfaces.photoalbum.search.SearchInformationHolder;
import org.richfaces.photoalbum.search.SearchOptionByAlbum;
import org.richfaces.photoalbum.search.SearchOptionByImage;
import org.richfaces.photoalbum.search.SearchOptionByShelf;
import org.richfaces.photoalbum.search.SearchOptionByTag;
import org.richfaces.photoalbum.search.SearchOptionByUser;
import org.richfaces.photoalbum.service.PhotoAlbumException;

@Named
@ApplicationScoped
public class ImageSearchHelper
implements Serializable {
    private static final long serialVersionUID = -304368268896942902L;
    @Inject
    ISearchAction searchAction;
    ISearchOption selectedOption;
    List<ISearchOption> options;
    String selectedTab;
    String searchQuery;
    String selectedKeyword;
    List<String> keywords = new ArrayList();
    boolean seachInMyAlbums;
    boolean searchInShared = true;
    private SearchInformationHolder searchOptionsHolder;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    @Inject
    @EventType(value=Events.UPDATE_MAIN_AREA_EVENT)
    Event<NavEvent> navEvent;

    public ImageSearchHelper() {
        this.options = new ArrayList();
        this.options.add(new SearchOptionByShelf());
        this.options.add(new SearchOptionByAlbum());
        this.options.add(new SearchOptionByImage());
        this.options.add(new SearchOptionByUser());
        this.options.add(new SearchOptionByTag());
    }

    public String getCriteriaString() {
        StringBuilder s = new StringBuilder();
        for (ISearchOption option : this.options) {
            if (!option.getSelected()) continue;
            s.append(option.getName() + "," + " ");
        }
        if (s.length() >= 2) {
            s.delete(s.length() - 2, s.length());
        }
        return s.toString();
    }

    public void search() {
        this.searchOptionsHolder = null;
        if (!this.isSearchOptionSelected()) {
            this.error.fire((Object)new ErrorEvent("You must select at least one search option"));
            return;
        }
        if (!this.isWhereSearchOptionSelected()) {
            this.error.fire((Object)new ErrorEvent("You must specify where to execute the search "));
            return;
        }
        this.keywords = new ArrayList();
        this.navEvent.fire((Object)new NavEvent(NavigationEnum.SEARCH));
        this.keywords = this.parse(this.searchQuery);
        Iterator it = this.options.iterator();
        this.selectedKeyword = ((String)this.keywords.get(0)).trim();
        while (it.hasNext()) {
            ISearchOption option = (ISearchOption)it.next();
            try {
                if (!option.getSelected()) continue;
                option.search(this.searchAction, this.selectedKeyword, this.seachInMyAlbums, this.searchInShared);
            }
            catch (PhotoAlbumException e) {
                this.error.fire((Object)new ErrorEvent("Error", option.getName() + ":" + e.getMessage()));
            }
        }
        this.searchOptionsHolder = new SearchInformationHolder(new ArrayList(this.options), this.seachInMyAlbums, this.searchInShared);
        this.searchQuery = "";
    }

    public void searchKeyword(String keyword) {
        if (!this.isSearchOptionSelected()) {
            this.error.fire((Object)new ErrorEvent("You must select at least one search option"));
            return;
        }
        Iterator it = this.searchOptionsHolder.getOptions().iterator();
        this.selectedKeyword = keyword.trim();
        while (it.hasNext()) {
            ISearchOption option = (ISearchOption)it.next();
            try {
                if (!option.getSelected()) continue;
                option.search(this.searchAction, this.selectedKeyword, this.searchOptionsHolder.isSeachInMyAlbums(), this.searchOptionsHolder.isSearchInShared());
            }
            catch (PhotoAlbumException e) {
                this.error.fire((Object)new ErrorEvent(option.getName() + ":" + e.getMessage()));
            }
        }
    }

    public void processSelection() {
        for (ISearchOption option : this.options) {
            if (!option.getSelected()) continue;
            this.selectedOption = option;
            break;
        }
    }

    public ISearchOption getSelectedOption() {
        return this.selectedOption;
    }

    public void setSelectedOption(ISearchOption selectedOption) {
        this.selectedOption = selectedOption;
    }

    public List<ISearchOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<ISearchOption> options) {
        this.options = options;
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public boolean isSeachInMyAlbums() {
        return this.seachInMyAlbums;
    }

    public void setSeachInMyAlbums(boolean seachInMyAlbums) {
        this.seachInMyAlbums = seachInMyAlbums;
    }

    public boolean isSearchInShared() {
        return this.searchInShared;
    }

    public void setSearchInShared(boolean searchInShared) {
        this.searchInShared = searchInShared;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public String getSelectedKeyword() {
        return this.selectedKeyword;
    }

    public void setSelectedKeyword(String selectedKeyword) {
        this.selectedKeyword = selectedKeyword;
    }

    public boolean isResultExist() {
        for (ISearchOption option : this.options) {
            if (!option.getSelected() || option.getSearchResult() == null || option.getSearchResult().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private List<String> parse(String searchQuery2) {
        return Arrays.asList(searchQuery2.split(","));
    }

    private boolean isWhereSearchOptionSelected() {
        return this.seachInMyAlbums || this.searchInShared;
    }

    boolean isOptionSelected() {
        return this.selectedOption != null;
    }

    private boolean isSearchOptionSelected() {
        boolean isOptionSelected = false;
        for (ISearchOption i : this.options) {
            if (!i.getSelected()) continue;
            isOptionSelected = true;
            break;
        }
        return isOptionSelected;
    }
}

