/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.service;

import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.richfaces.photoalbum.domain.Event;
import org.richfaces.photoalbum.domain.EventCategory;
import org.richfaces.photoalbum.service.IEventAction;
import org.richfaces.photoalbum.service.PhotoAlbumException;

@Stateless
public class EventAction
implements IEventAction {
    @Inject
    private EntityManager em;

    public void addEvent(Event event) throws PhotoAlbumException {
        try {
            this.em.persist((Object)event);
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void deleteEvent(Event event) throws PhotoAlbumException {
        try {
            this.em.remove(this.em.merge((Object)event));
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void editEvent(Event event) throws PhotoAlbumException {
        try {
            this.em.merge((Object)event);
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void resetEvent(Event event) {
        this.em.refresh((Object)event);
    }

    public List<Event> getAllEvents() {
        return this.em.createNamedQuery("all-events").getResultList();
    }

    public List<EventCategory> getEventCategories() {
        return this.em.createNamedQuery("event-categories").getResultList();
    }

    public Event getEventById(long id) {
        Event event = null;
        try {
            event = (Event)this.em.createNamedQuery("event-by-id").setParameter("id", (Object)id).getSingleResult();
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        return event;
    }

    public EventCategory getEventCategoryById(long id) {
        EventCategory ec = null;
        try {
            ec = (EventCategory)this.em.createNamedQuery("event-category").setParameter("id", (Object)id).getSingleResult();
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        return ec;
    }

    public Event getEventByName(String name) {
        Event event = null;
        try {
            event = (Event)this.em.createNamedQuery("event-by-name").setParameter("name", (Object)name).getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return event;
    }

    public List<Event> getEventsByCategory(EventCategory ec) {
        return this.em.createNamedQuery("events-by-category").setParameter("cat", (Object)ec).getResultList();
    }
}

