/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.social;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.json.JSONArray;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONObject;
import org.richfaces.photoalbum.event.ErrorEvent;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;

@Named
@ApplicationScoped
public class FacebookAlbumCache {
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    private Map<String, JSONObject> albums = new HashMap();
    private Map<String, Map<String, JSONObject>> images = new HashMap();
    private boolean needsUpdate = true;
    private String currentAlbumId;
    private String currentPhotoId;

    public void setAll(String json) {
        try {
            JSONObject jo = new JSONObject(json);
            if (!jo.has("albums")) {
                return;
            }
            this.storeAlbums(jo.getJSONArray("albums"));
            this.storeImagesToAlbum(jo.getJSONArray("images"));
            this.setNeedsUpdate(true);
        }
        catch (JSONException e) {
            this.error.fire((Object)new ErrorEvent("Error: ", e.getMessage()));
        }
    }

    public void storeAlbums(JSONArray ja) {
        this.storeAlbums(ja, false);
    }

    public void storeAlbums(JSONArray ja, boolean rewrite) {
        try {
            for (int i = 0; i < ja.length(); ++i) {
                String albumId;
                JSONObject jo = ja.getJSONObject(i);
                if (!jo.has("aid")) {
                    this.error.fire((Object)new ErrorEvent("Error, object does not contain albums"));
                }
                if (this.albums.containsKey(albumId = jo.getString("aid")) && !rewrite) {
                    return;
                }
                if (rewrite) {
                    this.albums.remove(albumId);
                }
                this.images.put(albumId, null);
                this.albums.put(albumId, jo);
            }
        }
        catch (JSONException je) {
            this.error.fire((Object)new ErrorEvent("Error", je.getMessage()));
        }
    }

    public void storeImagesToAlbum(JSONArray ja) {
        String imageId = "";
        String albumId = "";
        try {
            for (int i = 0; i < ja.length(); ++i) {
                JSONObject jo = ja.getJSONObject(i);
                if (!jo.has("aid") || !jo.has("pid")) {
                    this.error.fire((Object)new ErrorEvent("Error, object does not contain images"));
                }
                albumId = jo.getString("aid");
                imageId = jo.getString("pid");
                if (this.images.get(albumId) == null) {
                    this.images.put(albumId, new HashMap());
                }
                ((Map)this.images.get(albumId)).put(imageId, jo);
            }
        }
        catch (JSONException je) {
            this.error.fire((Object)new ErrorEvent("Error", je.getMessage()));
        }
    }

    public JSONObject getAlbum(String albumId) {
        return (JSONObject)this.albums.get(albumId);
    }

    public Map<String, JSONObject> getImagesOfAlbum(String albumId) {
        return (Map)this.images.get(albumId);
    }

    public List<JSONObject> getAlbums(List<String> albumIds) {
        if (albumIds == null) {
            return null;
        }
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (String id : albumIds) {
            list.add((JSONObject)this.albums.get(id));
        }
        return list;
    }

    public boolean areAlbumsLoaded(List<String> albumIds) {
        if (albumIds != null) {
            for (String id : albumIds) {
                if (this.images.get(id) != null) continue;
                this.setNeedsUpdate(true);
                return false;
            }
        }
        this.setNeedsUpdate(false);
        return true;
    }

    public boolean isNeedsUpdate() {
        return this.needsUpdate;
    }

    public void setNeedsUpdate(boolean needsUpdate) {
        this.needsUpdate = needsUpdate;
    }

    public String getCurrentAlbumId() {
        return this.currentAlbumId;
    }

    public void setCurrentAlbumId(String currentAlbumId) {
        this.currentAlbumId = currentAlbumId;
    }

    public String getCurrentPhotoId() {
        return this.currentPhotoId;
    }

    public void setCurrentPhotoId(String currentPhotoId) {
        this.currentPhotoId = currentPhotoId;
    }

    public JSONObject getCurrentAlbum() {
        return (JSONObject)this.albums.get(this.currentAlbumId);
    }

    public List<JSONObject> getCurrentPhotos() {
        return new ArrayList<JSONObject>(((Map)this.images.get(this.currentAlbumId)).values());
    }

    public JSONObject getCurrentPhoto() {
        return (JSONObject)((Map)this.images.get(this.currentAlbumId)).get(this.currentPhotoId);
    }
}

