/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.social;

import java.io.Serializable;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONObject;
import org.richfaces.photoalbum.domain.Album;
import org.richfaces.photoalbum.event.ErrorEvent;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.manager.FileDownloadManager;
import org.richfaces.photoalbum.service.IEventAction;
import org.richfaces.photoalbum.service.PhotoAlbumException;
import org.richfaces.photoalbum.social.FacebookAlbumCache;
import org.richfaces.ui.drag.dropTarget.DropEvent;
import org.richfaces.ui.drag.dropTarget.DropListener;

@Named(value="fbDndManager")
@SessionScoped
public class FacebookAlbumDndManager
implements Serializable,
DropListener {
    private static final long serialVersionUID = 1L;
    @Inject
    FacebookAlbumCache fac;
    @Inject
    IEventAction ea;
    @Inject
    FileDownloadManager fdm;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    private String albumId;
    private org.richfaces.photoalbum.domain.Event event;
    private boolean albumAlreadyShared;

    public void processDrop(DropEvent event) {
        this.albumId = (String)event.getDragValue();
        this.event = (org.richfaces.photoalbum.domain.Event)event.getDropValue();
        if (this.event.getFacebookAlbums().contains(this.albumId)) {
            this.setAlbumAlreadyShared(true);
            this.error.fire((Object)new ErrorEvent("This album is already shared in this event"));
            return;
        }
        String albumName = "";
        try {
            albumName = this.fac.getAlbum(this.albumId).getString("name");
        }
        catch (JSONException e) {
            // empty catch block
        }
        for (Album album : this.event.getShelf().getAlbums()) {
            if (album.getName() != albumName) continue;
            this.setAlbumAlreadyShared(true);
            this.error.fire((Object)new ErrorEvent("Album with this name has already been imported to this event"));
            return;
        }
        this.setAlbumAlreadyShared(false);
    }

    public void shareAlbum() {
        this.event.getFacebookAlbums().add(this.albumId);
        try {
            this.ea.editEvent(this.event);
        }
        catch (PhotoAlbumException pae) {
            this.error.fire((Object)new ErrorEvent("Error saving event", pae.getMessage()));
        }
    }

    public void importAlbum() {
        try {
            this.fdm.setUpDownload(this.fac.getAlbum(this.albumId).getString("name"), this.albumId, this.fac.getImagesOfAlbum(this.albumId), this.event);
        }
        catch (JSONException je) {
            this.error.fire((Object)new ErrorEvent("Error importing album", je.getMessage()));
        }
    }

    public String getAlbumId() {
        return this.albumId;
    }

    public void setAlbumId(String albumId) {
        this.albumId = albumId;
    }

    public JSONObject getAlbum() {
        return this.fac.getAlbum(this.getAlbumId());
    }

    public boolean isAlbumAlreadyShared() {
        return this.albumAlreadyShared;
    }

    public void setAlbumAlreadyShared(boolean albumAlreadyShared) {
        this.albumAlreadyShared = albumAlreadyShared;
    }
}

