/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.solder.logging.Logger;
import org.richfaces.photoalbum.domain.EventCategory;
import org.richfaces.photoalbum.domain.Shelf;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.event.ErrorEvent;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.EventTypeQualifier;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.ShelfEvent;
import org.richfaces.photoalbum.service.IEventAction;
import org.richfaces.photoalbum.service.IShelfAction;
import org.richfaces.photoalbum.util.Preferred;

@Named
@RequestScoped
public class EventManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean validationSuccess = false;
    @Inject
    IEventAction eventAction;
    @Inject
    IShelfAction shelfAction;
    @Inject
    @Preferred
    User user;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    @Inject
    @Any
    Event<ShelfEvent> shelfEvent;
    private org.richfaces.photoalbum.domain.Event newEvent = new org.richfaces.photoalbum.domain.Event();
    private Shelf newShelf = new Shelf();
    private long ecId;

    public org.richfaces.photoalbum.domain.Event getEvent() {
        return this.newEvent;
    }

    public void setEvent(org.richfaces.photoalbum.domain.Event event) {
        this.newEvent = event;
    }

    public void createEvent() {
        if (this.user == null) {
            return;
        }
        this.newEvent = new org.richfaces.photoalbum.domain.Event();
        this.ecId = 1L;
        this.newShelf = new Shelf();
    }

    public void addEvent() {
        if (this.user == null) {
            return;
        }
        this.validationSuccess = true;
        Logger logger = Logger.getLogger(EventManager.class);
        try {
            EventCategory ec = this.eventAction.getEventCategoryById(this.ecId);
            this.newEvent.setCategory(ec);
            this.newShelf.setName(this.newEvent.getName());
            this.newShelf.setShared(true);
            this.newShelf.setEvent(this.newEvent);
            this.newEvent.setShelf(this.newShelf);
            this.eventAction.addEvent(this.newEvent);
            this.shelfAction.addShelf(this.newShelf);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while saving the event to the database <br /> " + e.getMessage()));
            logger.error((Object)"exception occured", (Throwable)e);
            return;
        }
        this.shelfEvent.select(new Annotation[]{new EventTypeQualifier(Events.EVENT_ADDED_EVENT)}).fire((Object)new ShelfEvent(this.newEvent));
    }

    public void editEvent(org.richfaces.photoalbum.domain.Event event, boolean editFromInplace) {
        if (this.user == null) {
            return;
        }
        try {
            this.eventAction.editEvent(event);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while saving the event to the database <br /> " + e.getMessage()));
            this.eventAction.resetEvent(event);
            return;
        }
        this.shelfEvent.select(new Annotation[]{new EventTypeQualifier(Events.EVENT_EDITED_EVENT)}).fire((Object)new ShelfEvent(event));
    }

    public void deleteEvent(org.richfaces.photoalbum.domain.Event event) {
        if (this.user == null) {
            return;
        }
        try {
            this.eventAction.deleteEvent(event);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while deleting the event to the database <br /> " + e.getMessage()));
            return;
        }
        this.shelfEvent.select(new Annotation[]{new EventTypeQualifier(Events.EVENT_DELETED_EVENT)}).fire((Object)new ShelfEvent(event));
    }

    public boolean isValidationSuccess() {
        return this.validationSuccess;
    }

    public void setValidationSuccess(boolean validationSuccess) {
        this.validationSuccess = validationSuccess;
    }

    public List<org.richfaces.photoalbum.domain.Event> getAllEvents() {
        return this.eventAction.getAllEvents();
    }

    public List<EventCategory> getEventCategories() {
        return this.eventAction.getEventCategories();
    }

    public org.richfaces.photoalbum.domain.Event getEventById(long id) {
        return this.eventAction.getEventById(id);
    }

    public EventCategory getEventCategoryById(long id) {
        return this.eventAction.getEventCategoryById(id);
    }

    public List<org.richfaces.photoalbum.domain.Event> getEventsByCategory(EventCategory ec) {
        return this.eventAction.getEventsByCategory(ec);
    }

    public long getEcId() {
        return this.ecId;
    }

    public void setEcId(long ecId) {
        this.ecId = ecId;
    }
}

