/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.service;

import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.richfaces.photoalbum.domain.Shelf;
import org.richfaces.photoalbum.service.IShelfAction;
import org.richfaces.photoalbum.service.PhotoAlbumException;

@Stateless
public class ShelfAction
implements IShelfAction {
    @Inject
    private EntityManager em;

    public void addShelf(Shelf shelf) throws PhotoAlbumException {
        try {
            this.em.persist((Object)shelf);
            shelf.getOwner().addShelf(shelf);
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void deleteShelf(Shelf shelf) throws PhotoAlbumException {
        try {
            shelf.getOwner().removeShelf(shelf);
            this.em.remove(this.em.merge((Object)shelf));
            this.em.flush();
        }
        catch (Exception e) {
            shelf.getOwner().addShelf(shelf);
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void editShelf(Shelf shelf) throws PhotoAlbumException {
        try {
            this.em.merge((Object)shelf);
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public List<Shelf> getPredefinedShelves() {
        return this.em.createNamedQuery("user-shelves").getResultList();
    }

    public void resetShelf(Shelf shelf) {
        this.em.refresh((Object)shelf);
    }
}

