/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.social.gplus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.json.JSONArray;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONObject;
import org.richfaces.photoalbum.event.ErrorEvent;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.social.gplus.GooglePlusAlbumCache;

@Named
@SessionScoped
public class GooglePlusBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    @Inject
    GooglePlusAlbumCache gpac;
    private JSONObject userInfo;
    private List<JSONObject> userAlbums;

    public void setUserInfoJSON(String userJson) {
        try {
            this.userInfo = new JSONObject(userJson);
        }
        catch (JSONException e) {
            this.error.fire((Object)new ErrorEvent("Error", e.getMessage()));
        }
    }

    public JSONObject getUserInfo() {
        return this.userInfo;
    }

    public String getUserId() {
        return this.userInfo.optString("id");
    }

    public String getName() {
        JSONObject name = this.userInfo.optJSONObject("name");
        return name.optString("givenName") + " " + name.optString("familyName");
    }

    public List<JSONObject> getUserAlbums() {
        return this.userAlbums;
    }

    public void setUserAlbumsJSON(String albumJson) {
        JSONArray ja = new JSONArray();
        this.userAlbums = new ArrayList();
        try {
            ja = new JSONArray(albumJson);
            for (int i = 0; i < ja.length(); ++i) {
                this.userAlbums.add(ja.getJSONObject(i));
            }
            this.gpac.storeAlbums(this.userAlbums);
        }
        catch (JSONException e) {
            this.error.fire((Object)new ErrorEvent("Error", e.getMessage()));
        }
    }

    public List<String> getUserAlbumIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (JSONObject jo : this.userAlbums) {
            ids.add(this.getUserId() + ":" + jo.optString("id"));
        }
        return ids;
    }
}

