/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.util;

import org.richfaces.json.JSONObject;
import org.richfaces.photoalbum.domain.Image;

public class ImageHandler {
    private Image localImage;
    private JSONObject remoteImage;
    private int type;
    public static final int LOCAL = 1;
    public static final int FACEBOOK = 2;
    public static final int GOOGLE = 3;

    public ImageHandler(Object o) {
        if (o == null) {
            return;
        }
        if (o instanceof Image) {
            this.localImage = (Image)o;
            this.type = 1;
        } else if (o instanceof JSONObject) {
            this.remoteImage = (JSONObject)o;
            String imageType = this.remoteImage.optString("type");
            if (imageType.equals("facebook")) {
                this.type = 2;
            } else if (imageType.equals("google")) {
                this.type = 3;
            }
        }
    }

    public boolean isLocalImage() {
        return this.type == 1;
    }

    public boolean isFacebookImage() {
        return this.type == 2;
    }

    public boolean isGoogleImage() {
        return this.type == 3;
    }

    public Object getImage() {
        return this.isLocalImage() ? this.localImage : this.remoteImage;
    }

    public String getName() {
        return this.isLocalImage() ? this.localImage.getName() : this.remoteImage.optString("name");
    }

    public String getThumbUrl() {
        return this.isLocalImage() ? this.localImage.getFullPath() : this.remoteImage.optString("thumbUrl");
    }

    public String getId() {
        return this.isLocalImage() ? this.localImage.getId().toString() : this.remoteImage.optString("id");
    }

    public String getAlbumId() {
        return this.isLocalImage() ? this.localImage.getAlbum().getId().toString() : this.remoteImage.optString("fullAlbumId");
    }
}

