/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.util;

import java.io.IOException;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import org.richfaces.photoalbum.bean.UserBean;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.SimpleEvent;
import org.richfaces.photoalbum.manager.LoggedUserTracker;
import org.richfaces.photoalbum.util.Preferred;
import org.richfaces.photoalbum.util.Utils;

@RequestScoped
public class SessionExpirationChecker {
    @Inject
    UserBean userBean;
    @Inject
    LoggedUserTracker userTracker;
    @Inject
    @Preferred
    HttpSession session;

    public void checkUserExpiration(@Observes @EventType(value=Events.CHECK_USER_EXPIRED_EVENT) SimpleEvent se) {
        if (this.isShouldExpireUser(this.session)) {
            try {
                Utils.getSession().invalidate();
                FacesContext.getCurrentInstance().getExternalContext().redirect("error.jsf");
            }
            catch (IOException e1) {
                FacesContext.getCurrentInstance().responseComplete();
            }
        }
    }

    private boolean isShouldExpireUser(HttpSession session) {
        User user = this.userBean.getUser();
        return this.userBean.isLoggedIn() && user != null && this.userTracker.containsUserId(user.getId()) && !this.userTracker.containsUser(user.getId(), session.getId());
    }
}

