/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.domain;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.richfaces.photoalbum.domain.Image;
import org.richfaces.photoalbum.domain.Shelf;
import org.richfaces.photoalbum.domain.User;

@Entity
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class Album
implements Serializable {
    private static final long serialVersionUID = -7042878411608396483L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonProperty
    private Long id = null;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="album")
    @Fetch(value=FetchMode.SELECT)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @JsonProperty
    private List<Image> images = new ArrayList();
    @NotNull
    @ManyToOne
    @JoinColumn
    @OnDelete(action=OnDeleteAction.CASCADE)
    private Shelf shelf;
    @OneToOne(fetch=FetchType.EAGER)
    @JsonProperty
    private Image coveringImage;
    @Transient
    private boolean showAfterCreate;
    @Temporal(value=TemporalType.DATE)
    private Date created;
    @Column(length=255, nullable=false)
    @NotNull
    @NotEmpty
    @Length(min=3, max=50)
    @JsonProperty
    private String name;
    @Column(length=1024)
    @JsonProperty
    private String description;

    public Shelf getShelf() {
        return this.shelf;
    }

    public void setShelf(Shelf parent) {
        this.shelf = parent;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public List<Image> getUnvisitedImages() {
        ArrayList<Image> unvisitedImages = new ArrayList<Image>(this.getImages().size());
        for (Image i : this.getImages()) {
            if (!i.isNew()) continue;
            unvisitedImages.add(i);
        }
        return unvisitedImages;
    }

    public void setCoveringImage(Image coveringImage) {
        this.coveringImage = coveringImage;
    }

    public void addImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Null image!");
        }
        if (this.getImages().contains(image)) {
            return;
        }
        if (image.getAlbum() != null && !this.equals((Object)image.getAlbum())) {
            image.getAlbum().removeImage(image);
        }
        image.setAlbum(this);
        this.images.add(image);
    }

    public void removeImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Null image");
        }
        if (!image.getAlbum().equals((Object)this)) {
            throw new IllegalArgumentException("This album not contain this image!");
        }
        if (this.getCoveringImage().equals((Object)image)) {
            this.setCoveringImage(null);
        }
        this.images.remove(image);
    }

    public User getOwner() {
        return this.getShelf() != null ? this.getShelf().getOwner() : null;
    }

    public boolean isOwner(User user) {
        return user != null && user.equals((Object)this.getOwner());
    }

    public int getIndex(Image image) {
        if (this.isEmpty()) {
            return -1;
        }
        return this.images.indexOf(image);
    }

    public Image getCoveringImage() {
        if (this.coveringImage == null && !this.isEmpty()) {
            this.coveringImage = (Image)this.images.get(0);
        }
        return this.coveringImage;
    }

    public boolean isEmpty() {
        return this.images == null || this.images.isEmpty();
    }

    public boolean isPreDefined() {
        return this.getOwner().isPreDefined();
    }

    public String getPath() {
        if (this.getShelf() != null) {
            if (this.getShelf().getPath() == null) {
                return null;
            }
        } else {
            return File.separator + "event" + File.separator + this.getId() + File.separator;
        }
        return this.getShelf().getPath() + this.getId() + File.separator;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Album album = (Album)obj;
        if (this.id != null ? !this.id.equals(album.id) : album.id != null) {
            return false;
        }
        if (!this.shelf.equals((Object)album.shelf)) {
            return false;
        }
        return this.name.equals(album.name);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.shelf.hashCode();
        return result;
    }

    public String toString() {
        return "{id : " + this.getId() + ", name : " + this.getName() + "}";
    }

    public boolean isShowAfterCreate() {
        return this.showAfterCreate;
    }

    public void setShowAfterCreate(boolean showAfterCreate) {
        this.showAfterCreate = showAfterCreate;
    }
}

