/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.richfaces.photoalbum.domain.EventCategory;
import org.richfaces.photoalbum.domain.MediaItem;
import org.richfaces.photoalbum.domain.Shelf;
import org.richfaces.photoalbum.util.ListUtils;

@NamedQueries(value={@NamedQuery(name="event-categories", query="select ec from EventCategory ec"), @NamedQuery(name="event-category", query="select ec from EventCategory ec where ec.id = :id"), @NamedQuery(name="event-by-id", query="select e from Event e where e.id = :id"), @NamedQuery(name="all-events", query="select e from Event e"), @NamedQuery(name="event-by-name", query="select e from Event e where e.name = :name"), @NamedQuery(name="events-by-category", query="select e from Event e where e.category = :cat")})
@Entity
public class Event
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(unique=true)
    @NotNull
    @Size(min=5, max=50, message="An event's name must contain between 5 and 50 characters")
    private String name;
    @NotNull
    @Size(min=20, max=1000, message="An event's description must contain between 20 and 1000 characters")
    private String description;
    @ManyToOne
    private MediaItem mediaItem;
    @ManyToOne
    @NotNull
    private EventCategory category;
    @OneToOne
    @JoinColumn
    @OnDelete(action=OnDeleteAction.CASCADE)
    private Shelf shelf;
    @ElementCollection(fetch=FetchType.EAGER)
    private List<String> remoteAlbumIds = new ArrayList();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MediaItem getMediaItem() {
        return this.mediaItem;
    }

    public void setMediaItem(MediaItem picture) {
        this.mediaItem = picture;
    }

    public EventCategory getCategory() {
        return this.category;
    }

    public void setCategory(EventCategory category) {
        this.category = category;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getRemoteAlbumIds() {
        return this.remoteAlbumIds;
    }

    public void setRemoteAlbumIds(List<String> remoteAlbumIds) {
        this.remoteAlbumIds = remoteAlbumIds;
    }

    private List<String> getFilteredAlbumIds(String prefix) {
        ArrayList<String> filteredIds = new ArrayList<String>();
        int prefLength = prefix.length();
        for (String id : this.remoteAlbumIds) {
            if (!id.startsWith(prefix)) continue;
            filteredIds.add(id.substring(prefLength));
        }
        return filteredIds;
    }

    public List<String> getFacebookAlbumIds() {
        return this.getFilteredAlbumIds("F");
    }

    public List<String> getGooglePlusAlbumIds() {
        return this.getFilteredAlbumIds("G");
    }

    public String getFbAlbumIdString() {
        return ListUtils.sListToString((List)this.getFacebookAlbumIds());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return !(this.name != null ? !this.name.equals(event.name) : event.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return this.name;
    }

    public Shelf getShelf() {
        return this.shelf;
    }

    public void setShelf(Shelf shelf) {
        this.shelf = shelf;
    }
}

