/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.domain;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.OrderBy;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.richfaces.photoalbum.domain.Album;
import org.richfaces.photoalbum.domain.Event;
import org.richfaces.photoalbum.domain.Image;
import org.richfaces.photoalbum.domain.User;

@Entity
public class Shelf
implements Serializable {
    private static final long serialVersionUID = -7042878411608396483L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false)
    @NotNull
    @NotEmpty
    @Length(min=3, max=50)
    private String name;
    @Column(length=1024)
    private String description;
    @ManyToOne
    private User owner;
    @OneToOne
    @JoinColumn
    @OnDelete(action=OnDeleteAction.CASCADE)
    private Event event;
    @OneToMany(mappedBy="shelf", cascade={CascadeType.REMOVE})
    @OrderBy(clause="NAME asc")
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<Album> albums = new ArrayList();
    @NotNull
    private boolean shared;
    @Temporal(value=TemporalType.DATE)
    private Date created;

    public boolean isPreDefined() {
        return this.getOwner() != null && this.getOwner().isPreDefined();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Album> getAlbums() {
        return this.albums;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public boolean isOwner(User user) {
        return this.getOwner() != null && this.getOwner().equals((Object)user);
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public List<Image> getUnvisitedImages() {
        ArrayList<Image> unvisitedImages = new ArrayList<Image>();
        for (Album a : this.getAlbums()) {
            unvisitedImages.addAll(a.getUnvisitedImages());
        }
        return unvisitedImages;
    }

    public List<Image> getImages() {
        ArrayList<Image> images = new ArrayList<Image>();
        for (Album a : this.getAlbums()) {
            images.addAll(a.getImages());
        }
        return images;
    }

    public void addAlbum(Album album) {
        if (album == null) {
            throw new IllegalArgumentException("Null album!");
        }
        if (album.getShelf() != null && !album.getShelf().getAlbums().contains(this)) {
            album.getShelf().removeAlbum(album);
            album.setShelf(this);
            this.albums.add(album);
        }
    }

    public void removeAlbum(Album album) {
        if (album == null) {
            throw new IllegalArgumentException("Null album!");
        }
        if (!album.getShelf().equals((Object)this)) {
            throw new IllegalArgumentException("This Shelf not contain this album!");
        }
        this.albums.remove(album);
    }

    public Album getFirstAlbum() {
        if (this.albums.isEmpty()) {
            return null;
        }
        return (Album)this.albums.get(0);
    }

    public String getPath() {
        if (this.getOwner().getPath() == null) {
            return null;
        }
        return this.getOwner().getPath() + this.getId().toString() + File.separator;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Shelf shelf = (Shelf)obj;
        return (this.id != null ? this.id.equals(shelf.getId()) : shelf.getId() == null) && (this.owner != null ? this.owner.equals((Object)shelf.getOwner()) : shelf.getOwner() == null) && this.name.equals(shelf.getName());
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{id : " + this.getId() + ", name : " + this.getName() + "}";
    }
}

