/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.richfaces.photoalbum.domain.Shelf;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.event.ErrorEvent;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.EventTypeQualifier;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.ShelfEvent;
import org.richfaces.photoalbum.service.IShelfAction;
import org.richfaces.photoalbum.util.Preferred;

@Named
@RequestScoped
public class ShelfManager
implements Serializable {
    private static final long serialVersionUID = 2631634926126857691L;
    private boolean validationSuccess = false;
    private List<Shelf> shelves;
    @Inject
    IShelfAction shelfAction;
    @Inject
    @Preferred
    User user;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    @Inject
    @Any
    Event<ShelfEvent> shelfEvent;
    private Shelf newShelf = new Shelf();

    public Shelf getShelf() {
        return this.newShelf;
    }

    public void setShelf(Shelf shelf) {
        this.newShelf = shelf;
    }

    public void createShelf() {
        if (this.user == null) {
            return;
        }
        this.newShelf = new Shelf();
    }

    public void addShelf(Shelf shelf) {
        if (this.user == null) {
            return;
        }
        shelf.setOwner(this.user);
        if (this.user.hasShelfWithName(shelf)) {
            this.error.fire((Object)new ErrorEvent("You already have a shelf with the given name."));
            return;
        }
        this.validationSuccess = true;
        try {
            shelf.setCreated(new Date());
            this.shelfAction.addShelf(shelf);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while saving  the shelf to the database. <br/>" + e.getMessage()));
            return;
        }
        this.shelfEvent.select(new Annotation[]{new EventTypeQualifier(Events.SHELF_ADDED_EVENT)}).fire((Object)new ShelfEvent(shelf));
    }

    public void editShelf(Shelf shelf, boolean editFromInplace) {
        if (this.user == null) {
            return;
        }
        try {
            Validator validator;
            Set constraintViolations;
            if (this.user.hasShelfWithName(shelf)) {
                this.error.fire((Object)new ErrorEvent("You already have a shelf with the given name."));
                this.shelfAction.resetShelf(shelf);
                return;
            }
            if (editFromInplace && (constraintViolations = (validator = Validation.buildDefaultValidatorFactory().getValidator()).validate((Object)shelf, new Class[0])).size() > 0) {
                for (ConstraintViolation cv : constraintViolations) {
                    this.error.fire((Object)new ErrorEvent("Constraint violation", cv.getMessage()));
                }
                this.shelfAction.resetShelf(shelf);
                return;
            }
            this.shelfAction.editShelf(shelf);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while saving  the shelf to the database. <br/>" + e.getMessage()));
            this.shelfAction.resetShelf(shelf);
            return;
        }
        this.shelfEvent.select(new Annotation[]{new EventTypeQualifier(Events.SHELF_EDITED_EVENT)}).fire((Object)new ShelfEvent(shelf));
    }

    public void deleteShelf(Shelf shelf) {
        if (this.user == null) {
            return;
        }
        String pathToDelete = shelf.getPath();
        try {
            this.shelfAction.deleteShelf(shelf);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while deleting the shelf from the database. <br/>" + e.getMessage()));
            return;
        }
        this.shelfEvent.select(new Annotation[]{new EventTypeQualifier(Events.SHELF_DELETED_EVENT)}).fire((Object)new ShelfEvent(shelf, pathToDelete));
    }

    public List<Shelf> getPredefinedShelves() {
        if (this.shelves == null) {
            this.shelves = this.shelfAction.getPredefinedShelves();
        }
        return this.shelves;
    }

    public boolean isValidationSuccess() {
        return this.validationSuccess;
    }

    public void setValidationSuccess(boolean validationSuccess) {
        this.validationSuccess = validationSuccess;
    }
}

