/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.service;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.richfaces.photoalbum.domain.Album;
import org.richfaces.photoalbum.domain.Shelf;
import org.richfaces.photoalbum.service.IAlbumAction;
import org.richfaces.photoalbum.service.PhotoAlbumException;

@Stateless
public class AlbumAction
implements IAlbumAction {
    @Inject
    EntityManager em;

    public void addAlbum(Album album) throws PhotoAlbumException {
        try {
            this.em.persist((Object)album);
            album.getShelf().addAlbum(album);
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void deleteAlbum(Album album) throws PhotoAlbumException {
        Shelf parentShelf = album.getShelf();
        try {
            if (parentShelf == null) {
                return;
            }
            album.setCoveringImage(null);
            parentShelf.removeAlbum(album);
            this.em.remove(this.em.merge((Object)album));
            this.em.flush();
        }
        catch (Exception e) {
            parentShelf.addAlbum(album);
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void editAlbum(Album album) throws PhotoAlbumException {
        try {
            this.em.merge((Object)album);
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public Album resetAlbum(Album album) {
        Album a = (Album)this.em.merge((Object)album);
        this.em.refresh((Object)a);
        return a;
    }
}

