/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.social.gplus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.json.JSONArray;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONObject;
import org.richfaces.photoalbum.event.ErrorEvent;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;

@Named
@ApplicationScoped
public class GooglePlusAlbumCache {
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    private Map<String, JSONObject> albums = new HashMap();
    private Map<String, Map<String, JSONObject>> images = new HashMap();
    private String currentAlbumId;
    private String currentImageId;

    public void storeAlbums(List<JSONObject> albumsList) {
        this.storeAlbums(albumsList, false);
    }

    public void storeAlbums(List<JSONObject> albumsList, boolean rewrite) {
        try {
            for (JSONObject jo : albumsList) {
                String albumId = jo.getString("fullId");
                if (this.albums.containsKey(albumId) && !rewrite) {
                    return;
                }
                if (rewrite) {
                    this.albums.remove(albumId);
                }
                this.images.put(albumId, null);
                this.albums.put(albumId, jo);
            }
        }
        catch (JSONException je) {
            this.error.fire((Object)new ErrorEvent("Error", je.getMessage()));
        }
    }

    public void setAlbumImages(String imagesArray) {
        String imageId = "";
        String albumId = "";
        try {
            JSONArray ja = new JSONArray(imagesArray);
            this.currentAlbumId = albumId = ja.getJSONObject(0).getString("fullAlbumId");
            if (this.images.get(albumId) != null) {
                return;
            }
            int size = ja.length();
            ((JSONObject)this.albums.get(albumId)).put("size", size);
            this.images.put(albumId, new HashMap());
            for (int i = 0; i < size; ++i) {
                JSONObject jo = ja.getJSONObject(i);
                if (!jo.has("albumId") || !jo.has("id")) {
                    this.error.fire((Object)new ErrorEvent("Error, object does not contain images"));
                }
                imageId = jo.getString("id");
                ((Map)this.images.get(albumId)).put(imageId, jo);
            }
            ((JSONObject)this.albums.get(albumId)).put("size", ((Map)this.images.get(albumId)).size());
        }
        catch (JSONException je) {
            this.error.fire((Object)new ErrorEvent("Error", je.getMessage()));
        }
    }

    public JSONObject getAlbum(String albumId) {
        return (JSONObject)this.albums.get(albumId);
    }

    public Map<String, JSONObject> getImagesOfAlbum(String albumId) {
        return (Map)this.images.get(albumId);
    }

    public List<JSONObject> getAlbums(List<String> albumIds) {
        if (albumIds == null) {
            return null;
        }
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (String id : albumIds) {
            list.add((JSONObject)this.albums.get(id));
        }
        return list;
    }

    public String getCurrentAlbumId() {
        return this.currentAlbumId;
    }

    public void setCurrentAlbumId(String currentAlbumId) {
        this.currentAlbumId = currentAlbumId;
    }

    public String getCurrentImageId() {
        return this.currentImageId;
    }

    public void setCurrentImageId(String currentImageId) {
        this.currentImageId = currentImageId;
    }

    public JSONObject getCurrentAlbum() {
        return (JSONObject)this.albums.get(this.currentAlbumId);
    }

    public List<JSONObject> getCurrentImages() {
        return new ArrayList<JSONObject>(((Map)this.images.get(this.currentAlbumId)).values());
    }

    public JSONObject getCurrentImage() {
        return (JSONObject)((Map)this.images.get(this.currentAlbumId)).get(this.currentImageId);
    }

    public List<JSONObject> getAllImages() {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (Map album : this.images.values()) {
            if (album == null || album.values() == null || album.values().isEmpty()) continue;
            list.addAll(album.values());
        }
        return list;
    }

    public boolean isAlbumLoaded(String albumId) {
        return this.images.containsKey(albumId) && this.images.get(albumId) != null;
    }

    public void setAlbumAndImages(String aiJson) {
        try {
            JSONObject jAlbum = new JSONObject(aiJson);
            JSONArray albumImages = jAlbum.getJSONArray("images");
            jAlbum.remove("images");
            String albumId = jAlbum.getString("fullId");
            int size = albumImages.length();
            jAlbum.put("size", size);
            this.albums.put(albumId, jAlbum);
            this.images.put(albumId, new HashMap());
            Map album = (Map)this.images.get(albumId);
            for (int i = 0; i < albumImages.length(); ++i) {
                JSONObject jo = albumImages.getJSONObject(i);
                if (!jo.has("id")) {
                    this.error.fire((Object)new ErrorEvent("Error, object does not contain images"));
                }
                String imageId = jo.getString("id");
                album.put(imageId, jo);
            }
        }
        catch (JSONException je) {
            this.error.fire((Object)new ErrorEvent("Error", je.getMessage()));
        }
    }
}

