/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import javax.enterprise.context.RequestScoped;
import javax.faces.model.SelectItem;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.model.UploadedFile;
import org.richfaces.photoalbum.domain.Sex;
import org.richfaces.photoalbum.service.IUserAction;
import org.richfaces.ui.input.fileUpload.FileUploadEvent;

@Named
@RequestScoped
public class UserPrefsHelper
implements Serializable {
    private static final long serialVersionUID = -1767281809514660171L;
    @Inject
    IUserAction userAction;
    private File avatarData;
    static final SelectItem[] sexs = new SelectItem[]{new SelectItem((Object)Sex.MALE, "Male"), new SelectItem((Object)Sex.FEMALE, "Female")};

    public SelectItem[] getSexs() {
        return sexs;
    }

    public void uploadAvatar(FileUploadEvent event) {
        UploadedFile file = event.getUploadedFile();
        try {
            File f = new File(file.getName() + "avatar");
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(file.getData());
            fos.flush();
            fos.close();
            this.avatarData = f;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public File getAvatarData() {
        return this.avatarData;
    }

    public void setAvatarData(File avatarData) {
        this.avatarData = avatarData;
    }
}

