/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.util;

import java.io.Serializable;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.richfaces.photoalbum.domain.Comment;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.SimpleEvent;
import org.richfaces.photoalbum.manager.LoggedUserTracker;
import org.richfaces.photoalbum.service.IImageAction;
import org.richfaces.photoalbum.util.Environment;

@SessionScoped
public class SessionListener
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private User user;
    @Inject
    private IImageAction imageAction;
    @Inject
    private EntityManager em;
    @Inject
    LoggedUserTracker userTracker;
    @Inject
    @EventType(value=Events.USER_DELETED_EVENT)
    Event<SimpleEvent> event;

    @PreDestroy
    public void onDestroy() {
        if (!Environment.isInProduction()) {
            return;
        }
        if (this.user.getId() != null && !this.user.isPreDefined() && !this.userTracker.containsUserId(this.user.getId())) {
            this.user = (User)this.em.merge((Object)this.user);
            List userComments = this.imageAction.findAllUserComments(this.user);
            for (Comment c : userComments) {
                this.em.remove((Object)c);
            }
            this.em.remove((Object)this.user);
            this.em.flush();
            this.event.fire((Object)new SimpleEvent());
        }
    }
}

