/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo.push;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.Random;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import org.ajax4jsf.event.PushEventListener;
import org.richfaces.demo.push.Choice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ManagedBean(name="choicesBean")
@SessionScoped
public class ChoicesBean
implements Runnable {
    PushEventListener listener;
    private boolean enabled = false;
    private List<Choice> choices = new ArrayList();
    private List<Choice> lastVotes = new ArrayList();
    private Date startDate;
    private Thread thread;
    private String updateInfo;

    public ChoicesBean() {
        this.choices.add(new Choice("Orange"));
        this.choices.add(new Choice("Pineapple"));
        this.choices.add(new Choice("Banana"));
        this.choices.add(new Choice("Kiwifruit"));
        this.choices.add(new Choice("Apple"));
        this.lastVotes.add(new Choice("Orange"));
        this.lastVotes.add(new Choice("Pineapple"));
        this.lastVotes.add(new Choice("Banana"));
        this.lastVotes.add(new Choice("Kiwifruit"));
        this.lastVotes.add(new Choice("Apple"));
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public void setChoices(List<Choice> choices) {
        this.choices = choices;
    }

    public void addListener(EventListener listener) {
        if (this.listener != listener) {
            this.listener = (PushEventListener)listener;
        }
    }

    public Date getTimeStamp() {
        return new Date();
    }

    public synchronized void start() {
        if (this.thread == null) {
            this.setStartDate(new Date());
            this.setEnabled(true);
            this.thread = new Thread((Runnable)this);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.setStartDate(null);
            this.setEnabled(false);
            this.thread = null;
        }
    }

    public static int rand(int lo, int hi) {
        Random rn2 = new Random();
        int n = hi - lo + 1;
        int i = rn2.nextInt() % n;
        if (i < 0) {
            i = -i;
        }
        return lo + i;
    }

    @Override
    public void run() {
        while (this.thread != null) {
            try {
                if (new Date().getTime() - this.startDate.getTime() >= 60000L) {
                    this.stop();
                }
                for (Choice choice : this.lastVotes) {
                    choice.setVotesCount(ChoicesBean.rand((int)0, (int)3));
                }
                this.listener.onEvent(new EventObject(this));
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void processUpdates() {
        for (Choice choice : this.lastVotes) {
            if (choice.getVotesCount() <= 0) continue;
            int index = this.lastVotes.indexOf(choice);
            ((Choice)this.choices.get(index)).increment(choice.getVotesCount());
        }
        this.updateInfo = "[ ";
        for (Choice choice : this.lastVotes) {
            this.updateInfo = this.updateInfo + choice.getVotesCount() + " ";
        }
        this.updateInfo = this.updateInfo + "] ";
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public String getUpdateInfo() {
        return this.updateInfo;
    }

    public List<Choice> getLastVotes() {
        return this.lastVotes;
    }
}

