/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo.tables.model.expenses;

import java.util.ArrayList;
import java.util.List;
import org.richfaces.demo.tables.model.expenses.ExpenseReportRecord;
import org.richfaces.demo.tables.model.expenses.ExpenseReportRecordItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpenseReport {
    private List<ExpenseReportRecord> records = null;

    public List<ExpenseReportRecord> getRecords() {
        if (this.records == null) {
            this.initRecords();
        }
        return this.records;
    }

    public void setRecords(List<ExpenseReportRecord> records) {
        this.records = records;
    }

    public double getTotalMeals() {
        double ret = 0.0;
        for (ExpenseReportRecord record : this.getRecords()) {
            ret += record.getTotalMeals();
        }
        return ret;
    }

    public double getTotalHotels() {
        double ret = 0.0;
        for (ExpenseReportRecord record : this.getRecords()) {
            ret += record.getTotalHotels();
        }
        return ret;
    }

    public double getTotalTransport() {
        double ret = 0.0;
        for (ExpenseReportRecord record : this.getRecords()) {
            ret += record.getTotalTransport();
        }
        return ret;
    }

    public double getGrandTotal() {
        return this.getTotalMeals() + this.getTotalHotels() + this.getTotalTransport();
    }

    public int getRecordsCount() {
        return this.getRecords().size();
    }

    private void initRecords() {
        this.records = new ArrayList();
        ExpenseReportRecord rec = new ExpenseReportRecord();
        rec.setCity("San Jose");
        rec.getItems().add(new ExpenseReportRecordItem("25-Aug-97", 37.74, 112.0, 45.0, "San Jose"));
        rec.getItems().add(new ExpenseReportRecordItem("26-Aug-97", 27.28, 112.0, 45.0, "San Jose"));
        this.records.add(rec);
        rec = new ExpenseReportRecord();
        rec.setCity("Seattle");
        rec.getItems().add(new ExpenseReportRecordItem("27-Aug-97", 96.25, 109.0, 36.0, "Seattle"));
        rec.getItems().add(new ExpenseReportRecordItem("28-Aug-97", 35.0, 109.0, 36.0, "Seattle"));
        this.records.add(rec);
    }
}

