/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.util;

import com.google.common.base.Strings;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.AjaxClientBehavior;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.AbstractActionComponent;
import org.richfaces.component.attribute.AjaxProps;
import org.richfaces.renderkit.AjaxFunction;
import org.richfaces.renderkit.AjaxOptions;
import org.richfaces.renderkit.util.HandlersChain;
import org.richfaces.renderkit.util.RendererUtils;

public final class AjaxRendererUtils {
    public static final String BEGIN_EVENT_NAME = "begin";
    public static final String AJAX_ABORT_ATTR = "ignoreDupResponses";
    public static final String AJAX_AREAS_RENDERED = "org.ajax4jsf.areas.rendered";
    public static final String AJAX_DELAY_ATTR = "requestDelay";
    public static final String AJAX_QUEUE_ATTR = "eventsQueue";
    public static final String AJAX_SINGLE_ATTR = "ajaxSingle";
    public static final String AJAX_SINGLE_PARAMETER_NAME = "ajaxSingle";
    public static final String ERROR_EVENT_NAME = "error";
    public static final String ONBEGIN_ATTR_NAME = "onbegin";
    public static final String ONERROR_ATTR_NAME = "onerror";
    public static final String ONCOMPLETE_CONTENT_ID = "org.ajax4jsf.oncomplete";
    public static final String SIMILARITY_GROUPING_ID_ATTR = "similarityGroupingId";
    public static final String STATUS_ATTR_NAME = "status";
    public static final String VALUE_ATTR = "value";
    public static final String QUEUE_ID_ATTRIBUTE = "queueId";
    private static final RendererUtils RENDERER_UTILS = RendererUtils.getInstance();

    private AjaxRendererUtils() {
    }

    public static StringBuffer buildOnClick(UIComponent uiComponent, FacesContext facesContext) {
        return AjaxRendererUtils.buildOnClick(uiComponent, facesContext, false);
    }

    public static StringBuffer buildOnClick(UIComponent uiComponent, FacesContext facesContext, boolean omitDefaultActionUrl) {
        return AjaxRendererUtils.buildOnEvent(uiComponent, facesContext, "onclick", omitDefaultActionUrl);
    }

    public static StringBuffer buildOnEvent(UIComponent uiComponent, FacesContext facesContext, String eventName) {
        return AjaxRendererUtils.buildOnEvent(uiComponent, facesContext, eventName, false);
    }

    public static StringBuffer buildOnEvent(UIComponent uiComponent, FacesContext facesContext, String eventName, boolean omitDefaultActionUrl) {
        StringBuffer onEvent = new StringBuffer();
        return onEvent;
    }

    public static AjaxOptions buildEventOptions(FacesContext facesContext, UIComponent component) {
        AjaxOptions ajaxOptions = new AjaxOptions();
        AjaxRendererUtils.appendComponentOptions(facesContext, component, ajaxOptions);
        Map<String, Object> parametersMap = RENDERER_UTILS.createParametersMap(facesContext, component);
        ajaxOptions.addParameters(parametersMap);
        if (component instanceof AbstractActionComponent && component instanceof AjaxProps && ((AjaxProps)component).isResetValues()) {
            ajaxOptions.setParameter("javax.faces.partial.resetValues", true);
        }
        return ajaxOptions;
    }

    private static AjaxOptions buildAjaxOptions(ClientBehaviorContext behaviorContext, AjaxClientBehavior ajaxBehavior) {
        FacesContext facesContext = behaviorContext.getFacesContext();
        UIComponent component = behaviorContext.getComponent();
        AjaxOptions ajaxOptions = new AjaxOptions();
        Map<String, Object> parametersMap = RENDERER_UTILS.createParametersMap(facesContext, component);
        ajaxOptions.addParameters(parametersMap);
        String ajaxStatusName = ajaxBehavior.getStatus();
        if (Strings.isNullOrEmpty((String)ajaxStatusName)) {
            ajaxStatusName = AjaxRendererUtils.getAjaxStatus(component);
        }
        if (!Strings.isNullOrEmpty((String)ajaxStatusName)) {
            ajaxOptions.set(STATUS_ATTR_NAME, ajaxStatusName);
        }
        AjaxRendererUtils.appenAjaxBehaviorOptions(behaviorContext, ajaxBehavior, ajaxOptions);
        return ajaxOptions;
    }

    private static boolean isNotEmpty(String value) {
        return value != null && value.length() != 0;
    }

    private static void appenAjaxBehaviorOptions(ClientBehaviorContext behaviorContext, AjaxClientBehavior behavior, AjaxOptions ajaxOptions) {
        ajaxOptions.setParameter("javax.faces.behavior.event", behaviorContext.getEventName());
        ajaxOptions.setBeforesubmitHandler(behavior.getOnbeforesubmit());
        for (BehaviorOptionsData optionsData : BehaviorOptionsData.values()) {
            String optionValue = optionsData.getAttributeValue(behavior);
            if (!AjaxRendererUtils.isNotEmpty(optionValue)) continue;
            ajaxOptions.set(optionsData.toString(), optionValue);
        }
    }

    private static String getHandlerScript(FacesContext facesContext, UIComponent component, String attributeName, String eventName) {
        HandlersChain handlersChain = new HandlersChain(facesContext, component);
        String inlineHandler = (String)component.getAttributes().get(attributeName);
        handlersChain.addInlineHandlerAsValue(inlineHandler);
        handlersChain.addBehaviors(eventName);
        return handlersChain.toScript();
    }

    private static void appendComponentOptions(FacesContext facesContext, UIComponent component, AjaxOptions ajaxOptions) {
        String queueId;
        String handlerScript = AjaxRendererUtils.getHandlerScript(facesContext, component, ONBEGIN_ATTR_NAME, BEGIN_EVENT_NAME);
        if (!Strings.isNullOrEmpty((String)handlerScript)) {
            ajaxOptions.set(BEGIN_EVENT_NAME, handlerScript);
        }
        if (!Strings.isNullOrEmpty((String)(handlerScript = AjaxRendererUtils.getHandlerScript(facesContext, component, ONERROR_ATTR_NAME, ERROR_EVENT_NAME)))) {
            ajaxOptions.set(ERROR_EVENT_NAME, handlerScript);
        }
        if (!Strings.isNullOrEmpty((String)(queueId = AjaxRendererUtils.getQueueId(component)))) {
            ajaxOptions.set(QUEUE_ID_ATTRIBUTE, queueId);
        }
        ajaxOptions.set("incId", "1");
        String status = AjaxRendererUtils.getAjaxStatus(component);
        if (!Strings.isNullOrEmpty((String)status)) {
            ajaxOptions.set(STATUS_ATTR_NAME, status);
        }
    }

    public static AjaxFunction buildAjaxFunction(FacesContext facesContext, UIComponent component) {
        return new AjaxFunction(component.getClientId(facesContext), AjaxRendererUtils.buildEventOptions(facesContext, component));
    }

    public static AjaxFunction buildAjaxFunction(ClientBehaviorContext behaviorContext, AjaxClientBehavior behavior) {
        Object source;
        AjaxOptions options = AjaxRendererUtils.buildAjaxOptions(behaviorContext, behavior);
        if (behaviorContext.getSourceId() != null) {
            source = behaviorContext.getSourceId();
        } else {
            source = JSReference.THIS;
            FacesContext facesContext = behaviorContext.getFacesContext();
            UIComponent component = behaviorContext.getComponent();
            options.setAjaxComponent(component.getClientId(facesContext));
            options.set("sourceId", source);
        }
        return new AjaxFunction(source, options);
    }

    public static String getAjaxStatus(UIComponent component) {
        return (String)component.getAttributes().get(STATUS_ATTR_NAME);
    }

    public static String getQueueId(UIComponent component) {
        return (String)component.getAttributes().get(QUEUE_ID_ATTRIBUTE);
    }

    public static JSFunctionDefinition buildAjaxOncomplete(String body) {
        JSFunctionDefinition function = new JSFunctionDefinition(new Object[]{"request", "event", "data"});
        function.addToBody((Object)body);
        return function;
    }

    public static JSFunctionDefinition buildAjaxOnBeforeDomUpdate(String body) {
        JSFunctionDefinition function = new JSFunctionDefinition(new Object[]{"request", "event", "data"});
        function.addToBody((Object)body);
        return function;
    }

    private static enum BehaviorOptionsData {
        begin{

            @Override
            public String getAttributeValue(AjaxClientBehavior behavior) {
                return behavior.getOnbegin();
            }
        }
        ,
        error{

            @Override
            public String getAttributeValue(AjaxClientBehavior behavior) {
                return behavior.getOnerror();
            }
        }
        ,
        queueId{

            @Override
            public String getAttributeValue(AjaxClientBehavior behavior) {
                return behavior.getQueueId();
            }
        };


        public abstract String getAttributeValue(AjaxClientBehavior var1);
    }
}

