/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk;

import com.google.inject.Inject;
import java.io.File;
import java.net.URI;
import org.richfaces.cdk.NamingConventions;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.ComponentModel;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.model.InvalidNameException;
import org.richfaces.cdk.model.Name;
import org.richfaces.cdk.model.RendererModel;
import org.richfaces.cdk.util.Strings;

public final class RichFaces5Conventions
implements NamingConventions {
    private static final String ABSTRACT = "Abstract";
    private static final String BASE = "Base";
    private static final String UI = "UI";
    private static final String[] COMPONENT_SUFFIXES = new String[]{"Base"};
    private static final String[] COMPONENT_PREFIXES = new String[]{"UI", "Abstract"};
    private String baseName;
    @Inject
    private ComponentLibrary library;

    public FacesId inferComponentType(ClassName componentClass) throws InvalidNameException {
        Name name = this.inferNameByClass(componentClass, null, null);
        return FacesId.parseId((String)("org.richfaces.ui." + name.getSimpleName()));
    }

    private Name inferNameByClass(ClassName componentClass, Name.Classifier classifier, String markup) {
        if (null == componentClass) {
            throw new IllegalArgumentException();
        }
        Name name = Name.create((String)componentClass.toString());
        this.processName(classifier, markup, name);
        return name;
    }

    private Name inferNameByType(FacesId type, Name.Classifier classifier, String markup) {
        if (null == type) {
            throw new IllegalArgumentException();
        }
        Name name = Name.create((String)type.toString());
        this.processName(classifier, markup, name);
        return name;
    }

    private void processName(Name.Classifier classifier, String markup, Name name) {
        String baseName = this.getBaseName();
        if (null != baseName) {
            name.setPrefix(baseName);
        }
        name.setClassifier(classifier);
        name.setMarkup(markup);
        String simpleName = name.getSimpleName();
        simpleName = this.removeCommonPreffix(simpleName);
        simpleName = this.removeCommonSuffix(simpleName);
        name.setSimpleName(simpleName);
    }

    public ClassName inferUIComponentClass(FacesId componentType) throws InvalidNameException {
        if (null == componentType) {
            throw new IllegalArgumentException();
        }
        Name name = this.inferBasicName(componentType);
        name.setSimpleName(UI + name.getSimpleName());
        return new ClassName(name.toString());
    }

    public FacesId inferUIComponentFamily(FacesId componentType) {
        if (null == componentType) {
            throw new IllegalArgumentException();
        }
        return FacesId.parseId((String)(componentType.toString() + "Family"));
    }

    public ClassName inferTagHandlerClass(FacesId componentType, String markup) {
        if (null == componentType) {
            throw new IllegalArgumentException();
        }
        Name name = this.inferBasicName(componentType);
        name.setSimpleName(name.getSimpleName() + "Handler");
        return new ClassName(name.toString());
    }

    private Name inferBasicName(FacesId componentType) {
        ComponentModel component = this.library.getComponentByType(componentType);
        String baseClassName = component.getBaseClass().getName();
        Name name = Name.create((String)baseClassName);
        name.setClassifier(null);
        name.setMarkup(null);
        String simpleName = name.getSimpleName();
        simpleName = simpleName.replaceFirst("^Abstract", "");
        name.setSimpleName(simpleName);
        return name;
    }

    public String inferTagName(FacesId componentType) {
        if (null == componentType) {
            throw new IllegalArgumentException();
        }
        Name name = Name.create((String)componentType.toString());
        return Strings.firstToLowerCase((String)name.getSimpleName());
    }

    protected String getBaseName() {
        return this.baseName;
    }

    public FacesId inferRendererTypeByTemplatePath(String templateName) {
        String rendererType = new File(templateName).getName();
        rendererType = rendererType.split("\\.")[0];
        rendererType = rendererType.replaceFirst("^.", new String(new char[]{rendererType.charAt(0)}).toUpperCase());
        return FacesId.parseId((String)("org.richfaces.ui." + rendererType + "Renderer"));
    }

    public ClassName inferBehaviorClass(FacesId id) {
        if (null == id) {
            throw new IllegalArgumentException();
        }
        Name name = Name.create((String)id.toString());
        name.setClassifier(Name.Classifier.component);
        name.setMarkup("behavior");
        return new ClassName(name.toString());
    }

    public FacesId inferBehaviorType(ClassName targetClass) {
        Name name = this.inferNameByClass(targetClass, Name.Classifier.component, "html");
        return new FacesId(name.toString());
    }

    private String removeCommonSuffix(String simpleName) {
        for (int i = 0; i < COMPONENT_SUFFIXES.length; ++i) {
            if (!simpleName.endsWith(COMPONENT_SUFFIXES[i])) continue;
            simpleName = simpleName.substring(0, simpleName.length() - COMPONENT_SUFFIXES[i].length());
            break;
        }
        return simpleName;
    }

    private String removeCommonPreffix(String simpleName) {
        for (int i = 0; i < COMPONENT_PREFIXES.length; ++i) {
            if (!simpleName.startsWith(COMPONENT_PREFIXES[i])) continue;
            simpleName = simpleName.substring(COMPONENT_PREFIXES[i].length());
            break;
        }
        return simpleName;
    }

    public String inferTaglibName(String uri) throws InvalidNameException {
        try {
            URI taglibUri = URI.create(uri);
            String path = taglibUri.getPath();
            if (null != path) {
                int indexOfDot;
                int lastIndexOfPathSeparator = path.lastIndexOf(47);
                if (lastIndexOfPathSeparator >= 0) {
                    path = path.substring(lastIndexOfPathSeparator + 1);
                }
                if ((indexOfDot = path.indexOf(46)) > 0) {
                    path = path.substring(0, indexOfDot);
                }
                return path;
            }
            throw new InvalidNameException("Invalid taglib uri, no path defined " + uri);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidNameException("Invalid taglib uri " + uri + " , " + e.getMessage());
        }
    }

    public String inferTaglibUri(ComponentLibrary library) {
        return "http://richfaces.org";
    }

    public ClassName inferRendererClass(FacesId rendererType) {
        if (null == rendererType) {
            throw new IllegalArgumentException();
        }
        RendererModel renderer = this.library.getRendererByType(rendererType);
        String baseClassName = renderer.getBaseClass().getName();
        Name name = Name.create((String)baseClassName);
        name.setClassifier(null);
        name.setMarkup(null);
        String simpleName = name.getSimpleName();
        simpleName = simpleName.replaceFirst("Base$", "");
        name.setSimpleName(simpleName);
        return new ClassName(name.toString());
    }

    public FacesId inferRendererFamily(FacesId type) {
        return FacesId.parseId((String)this.inferNameByType(type, null, null).toString());
    }

    public FacesId inferRendererType(ClassName targetClass) {
        return FacesId.parseId((String)this.inferNameByClass(targetClass, Name.Classifier.renderkit, null).toString());
    }

    public FacesId inferRendererType(FacesId id) {
        return FacesId.parseId((String)this.inferNameByType(id, Name.Classifier.renderkit, null).toString());
    }
}

