/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.deployment;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.webapp.FacesServlet;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.facesconfig20.FacesConfigVersionType;
import org.jboss.shrinkwrap.descriptor.api.facesconfig20.WebFacesConfigDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.richfaces.arquillian.configuration.FundamentalTestConfiguration;
import org.richfaces.arquillian.configuration.FundamentalTestConfigurationContext;

public class BaseDeployment {
    private final Logger log = Logger.getLogger(BaseDeployment.class.getName());
    private final FundamentalTestConfiguration configuration = FundamentalTestConfigurationContext.getProxy();
    private final File cacheDir = new File("target/shrinkwrap-resolver-cache/");
    private WebArchive archive;
    private WebFacesConfigDescriptor facesConfig;
    private WebAppDescriptor webXml;
    private Set<String> mavenDependencies = Sets.newHashSet();
    private Set<String> excludedMavenDependencies = Sets.newHashSet();

    protected BaseDeployment(Class<?> testClass) {
        this.archive = testClass != null ? (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(testClass.getSimpleName() + ".war")) : (WebArchive)ShrinkWrap.create(WebArchive.class);
        this.facesConfig = ((WebFacesConfigDescriptor)Descriptors.create(WebFacesConfigDescriptor.class)).version(FacesConfigVersionType._2_0);
        this.webXml = (WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).version("3.0").addNamespace("xmlns:web", "http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd")).getOrCreateWelcomeFileList().welcomeFile(new String[]{"faces/index.xhtml"}).up()).getOrCreateContextParam().paramName("javax.faces.PROJECT_STAGE").paramValue("Development").up()).getOrCreateServlet().servletName(FacesServlet.class.getSimpleName()).servletClass(FacesServlet.class.getName()).loadOnStartup(Integer.valueOf(1)).up()).getOrCreateServletMapping().servletName(FacesServlet.class.getSimpleName()).urlPattern(new String[]{"*.jsf"}).up()).getOrCreateServletMapping().servletName(FacesServlet.class.getSimpleName()).urlPattern(new String[]{"/faces/*"}).up();
        if (this.configuration.servletContainerSetup()) {
            this.log.info("Adding Servlet Container extensions for JSF");
            this.withServletContainerSetup();
        }
        if (this.configuration.isCurrentRichFacesVersion()) {
            this.addRequiredMavenDependencies();
        } else {
            this.log.info("Running test against RichFaces version: " + this.configuration.getRichFacesVersion());
        }
        if (this.configuration.getMavenSettings() != null && !this.configuration.getMavenSettings().isEmpty()) {
            this.log.info("Use Maven Settings: " + this.configuration.getMavenSettings());
        }
    }

    public WebArchive archive() {
        return this.archive;
    }

    public WebArchive getFinalArchive() {
        WebArchive finalArchive = (WebArchive)((WebArchive)this.archive.addAsWebInfResource((Asset)new StringAsset(this.facesConfig.exportAsString()), "faces-config.xml")).addAsWebInfResource((Asset)new StringAsset(this.webXml.exportAsString()), "web.xml");
        this.exportMavenDependenciesToArchive(finalArchive);
        return finalArchive;
    }

    public void facesConfig(Function<WebFacesConfigDescriptor, WebFacesConfigDescriptor> transform) {
        this.facesConfig = (WebFacesConfigDescriptor)transform.apply((Object)this.facesConfig);
    }

    public void webXml(Function<WebAppDescriptor, WebAppDescriptor> transform) {
        this.webXml = (WebAppDescriptor)transform.apply((Object)this.webXml);
    }

    private void exportMavenDependenciesToArchive(WebArchive finalArchive) {
        HashSet jarFiles = Sets.newHashSet();
        for (String dependency : this.mavenDependencies) {
            try {
                File dependencyDir = new File(this.cacheDir, dependency);
                if (!dependencyDir.exists()) {
                    this.resolveMavenDependency(dependency, dependencyDir);
                } else if (this.dependencyDirIsStale(dependencyDir)) {
                    this.cleanDependencyDir(dependencyDir);
                    this.resolveMavenDependency(dependency, dependencyDir);
                }
                File[] listFiles = dependencyDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                });
                jarFiles.addAll(Arrays.asList(listFiles));
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't resolve maven dependency: " + dependency, e);
            }
        }
        File[] files = jarFiles.toArray(new File[jarFiles.size()]);
        finalArchive.addAsLibraries(files);
    }

    private boolean dependencyDirIsStale(File dir) {
        long lastModified = dir.lastModified();
        long expires = lastModified + 720000L;
        return System.currentTimeMillis() > expires;
    }

    private void cleanDependencyDir(File dir) {
        for (File file : dir.listFiles()) {
            file.delete();
        }
        dir.delete();
    }

    public BaseDeployment addMavenDependency(String ... dependencies) {
        this.mavenDependencies.addAll(Arrays.asList(dependencies));
        return this;
    }

    public BaseDeployment excludeMavenDependency(String ... dependencies) {
        this.excludedMavenDependencies.addAll(Arrays.asList(dependencies));
        return this;
    }

    private BaseDeployment withServletContainerSetup() {
        this.addMavenDependency(this.configuration.getJsfImplementation());
        this.addMavenDependency("org.jboss.weld.servlet:weld-servlet");
        this.excludeMavenDependency("slf4j-api");
        this.addMavenDependency("org.jboss.el:jboss-el");
        this.excludeMavenDependency("el-api");
        this.addMavenDependency("javax.annotation:jsr250-api:1.0");
        this.addMavenDependency("javax.servlet:jstl:1.2");
        this.webXml(new Function<WebAppDescriptor, WebAppDescriptor>(){

            public WebAppDescriptor apply(WebAppDescriptor webXml) {
                webXml.createListener().listenerClass("org.jboss.weld.environment.servlet.Listener");
                switch (BaseDeployment.this.configuration.getJsfProvider()) {
                    case MOJARRA: {
                        webXml.getOrCreateContextParam().paramName("com.sun.faces.expressionFactory").paramValue("org.jboss.el.ExpressionFactoryImpl");
                        break;
                    }
                    case MYFACES: {
                        webXml.getOrCreateContextParam().paramName("org.apache.myfaces.EXPRESSION_FACTORY").paramValue("org.jboss.el.ExpressionFactoryImpl");
                    }
                }
                return webXml;
            }
        });
        return this;
    }

    private void addRequiredMavenDependencies() {
        this.addMavenDependency("com.google.guava:guava", "net.sourceforge.cssparser:cssparser");
    }

    private void resolveMavenDependency(String missingDependency, File dir) {
        MavenResolverSystem resolver = this.getMavenResolver();
        JavaArchive[] dependencies = missingDependency.matches("^[^:]+:[^:]+:[^:]+") ? (JavaArchive[])((MavenFormatStage)((MavenStrategyStage)((MavenStrategyStage)resolver.resolve(missingDependency)).withClassPathResolution(false)).withTransitivity()).as(JavaArchive.class) : (JavaArchive[])((MavenFormatStage)((MavenStrategyStage)((MavenStrategyStage)((PomEquippedResolveStage)resolver.loadPomFromFile("pom.xml")).resolve(missingDependency)).withClassPathResolution(false)).withTransitivity()).as(JavaArchive.class);
        for (JavaArchive archive : dependencies) {
            dir.mkdirs();
            if (this.mavenDependencyExcluded(archive.getName())) continue;
            File outputFile = new File(dir, archive.getName());
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(outputFile, true);
        }
    }

    private MavenResolverSystem getMavenResolver() {
        String mavenSettings = this.configuration.getMavenSettings();
        if (mavenSettings == null || mavenSettings.isEmpty()) {
            return Maven.resolver();
        }
        return (MavenResolverSystem)Maven.configureResolver().fromFile(mavenSettings);
    }

    private boolean mavenDependencyExcluded(String archiveName) {
        for (String exclude : this.excludedMavenDependencies) {
            if (!archiveName.contains(exclude)) continue;
            return true;
        }
        return false;
    }
}

