/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.arquillian.browser;

import com.opera.core.systems.OperaDriver;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public enum Browser {
    FIREFOX(FirefoxDriver.class, "firefox"),
    INTERNET_EXPLORER(InternetExplorerDriver.class, new String[0]),
    CHROME(ChromeDriver.class, "chrome"),
    OPERA(OperaDriver.class, new String[0]),
    HTML_UNIT(HtmlUnitDriver.class, new String[0]),
    PHANTOMJS(PhantomJSDriver.class, "phantomjs");

    private final Class<?> clazz;
    private final Set<String> browserNames;

    private Browser(Class<?> clazz, String ... browserNames) {
        this.clazz = clazz;
        this.browserNames = new HashSet<String>(Arrays.asList(browserNames));
    }

    public static Browser getCurrentType(WebDriver wd) {
        for (Browser type : Browser.values()) {
            String browserName;
            if (type.clazz.isInstance(wd)) {
                return type;
            }
            if (!(wd instanceof RemoteWebDriver) || !type.browserNames.contains(browserName = ((RemoteWebDriver)wd).getCapabilities().getBrowserName())) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown Driver");
    }

    public boolean is(WebDriver wd) {
        Browser type = Browser.getCurrentType(wd);
        return type == this;
    }
}

