/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.ClientBehaviorBase;
import javax.faces.render.Renderer;
import javax.faces.view.facelets.BehaviorHandler;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.ConverterHandler;
import javax.xml.validation.ValidatorHandler;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.ModelValidator;
import org.richfaces.cdk.NamingConventions;
import org.richfaces.cdk.annotations.TagType;
import org.richfaces.cdk.apt.DummyPropertyImpl;
import org.richfaces.cdk.apt.SourceUtils;
import org.richfaces.cdk.model.BehaviorModel;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.ComponentModel;
import org.richfaces.cdk.model.ConverterModel;
import org.richfaces.cdk.model.DescriptionGroup;
import org.richfaces.cdk.model.EventModel;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.model.FacetModel;
import org.richfaces.cdk.model.GeneratedFacesComponent;
import org.richfaces.cdk.model.InvalidNameException;
import org.richfaces.cdk.model.ModelElementBase;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.model.RenderKitModel;
import org.richfaces.cdk.model.RendererModel;
import org.richfaces.cdk.model.TagModel;
import org.richfaces.cdk.model.Taglib;
import org.richfaces.cdk.model.ValidatorModel;
import org.richfaces.cdk.model.validator.CallbackException;
import org.richfaces.cdk.model.validator.NamingConventionsCallback;
import org.richfaces.cdk.util.Strings;

public class RichFaces5Validator
implements ModelValidator {
    public static final ClassName DEFAULT_COMPONENT_HANDLER = new ClassName(ComponentHandler.class);
    public static final ClassName DEFAULT_VALIDATOR_HANDLER = new ClassName(ValidatorHandler.class);
    public static final ClassName DEFAULT_CONVERTER_HANDLER = new ClassName(ConverterHandler.class);
    public static final ClassName DEFAULT_BEHAVIOR_HANDLER = new ClassName(BehaviorHandler.class);
    public static final ImmutableSet<String> SPECIAL_PROPERTIES = ImmutableSet.of((Object)"eventNames", (Object)"defaultEventName", (Object)"clientBehaviors", (Object)"family");
    @Inject
    private Logger log;
    private final NamingConventions namingConventions;
    private final Provider<SourceUtils> sourceUtilsProvider;

    @Inject
    public RichFaces5Validator(NamingConventions namingConventions, Provider<SourceUtils> sourceUtilsProvider) {
        this.namingConventions = namingConventions;
        this.sourceUtilsProvider = sourceUtilsProvider;
    }

    public void verify(ComponentLibrary library) throws CdkException {
        this.verifyComponents(library);
        this.verifyEvents(library);
        this.verifyRenderers(library);
        this.verifyTaglib(library);
        this.verifyBehaviors(library);
        this.verifyConverters(library);
        this.verifyValidators(library);
    }

    private void verifyValidators(ComponentLibrary library) {
        for (ValidatorModel validator : library.getValidators()) {
            this.verifyTypes((GeneratedFacesComponent)validator, new ValidatorTypeCallback(validator));
        }
    }

    protected void verifyConverters(ComponentLibrary library) {
        for (ConverterModel converter : library.getConverters()) {
            this.verifyTypes((GeneratedFacesComponent)converter, new ConverterTypeCallback(converter));
        }
    }

    protected void verifyEvents(ComponentLibrary library) {
        for (EventModel event : library.getEvents()) {
            ClassName sourceInterface;
            String methodName;
            ClassName listenerInterface = event.getListenerInterface();
            SourceUtils sourceUtils = (SourceUtils)this.sourceUtilsProvider.get();
            if (null != listenerInterface) {
                event.setGenerateListener(!sourceUtils.isClassExists(listenerInterface));
            }
            if (null == (methodName = event.getListenerMethod())) {
                methodName = "process";
                event.setListenerMethod(methodName);
            }
            if (null != (sourceInterface = event.getSourceInterface())) {
                event.setGenerateSource(!sourceUtils.isClassExists(sourceInterface));
            }
            for (ComponentModel component : library.getComponents()) {
                for (EventModel componentEvent : component.getEvents()) {
                    if (!event.getType().equals((Object)componentEvent.getType())) continue;
                    componentEvent.merge(event);
                }
            }
        }
    }

    protected void verifyTaglib(ComponentLibrary library) {
        String shortName;
        String uri;
        Taglib taglib = library.getTaglib();
        if (null == taglib) {
            taglib = new Taglib();
            library.setTaglib(taglib);
        }
        if (null == (uri = taglib.getUri())) {
            uri = this.namingConventions.inferTaglibUri(library);
            taglib.setUri(uri);
        }
        if (null == (shortName = taglib.getShortName())) {
            shortName = this.namingConventions.inferTaglibName(uri);
            taglib.setShortName(shortName);
        }
        for (ComponentModel component : library.getComponents()) {
            if (null == component.getRendererType() || !component.getTags().isEmpty()) continue;
            TagModel tag = new TagModel();
            this.verifyTag(tag, component.getId(), DEFAULT_COMPONENT_HANDLER);
            component.getTags().add((Object)tag);
        }
    }

    protected void verifyBehaviors(ComponentLibrary library) {
        for (BehaviorModel behavior : library.getBehaviors()) {
            this.verifyTypes((GeneratedFacesComponent)behavior, new BehaviorTypeCallback(behavior));
            for (TagModel tag : behavior.getTags()) {
                this.verifyTag(tag, behavior.getId(), DEFAULT_BEHAVIOR_HANDLER);
            }
        }
    }

    protected void verifyRenderers(ComponentLibrary library) {
        for (RenderKitModel renderKit : library.getRenderKits()) {
            for (RendererModel renderer : renderKit.getRenderers()) {
                try {
                    this.vefifyRenderer(library, renderer);
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Caught error when verifying renderer " + renderer, e);
                }
            }
        }
    }

    protected void vefifyRenderer(ComponentLibrary library, RendererModel renderer) {
        String baseName = renderer.getBaseClass().getSimpleName().replaceFirst("Base$", "");
        if (null == renderer.getId()) {
            if (null == renderer.getTemplate().getTemplatePath()) {
                throw new IllegalArgumentException("templatePath must not be null");
            }
            renderer.setId(this.namingConventions.inferRendererTypeByTemplatePath(renderer.getTemplate().getTemplatePath()));
        }
        if (null == renderer.getFamily()) {
            renderer.setFamily(this.namingConventions.inferRendererFamily(renderer.getId()));
        }
        this.verifyTypes((GeneratedFacesComponent)renderer, new RendererTypeCallback(library, renderer));
        for (ComponentModel component : library.getComponents()) {
            if (renderer.getId().equals((Object)component.getRendererType())) {
                this.copyRendererAttributes(renderer, component);
                continue;
            }
            if (!this.hasRendererSameBaseNameAsComponent(renderer, component)) continue;
            this.copyRendererAttributes(renderer, component);
            component.setRendererType(renderer.getId());
        }
        if (renderer.getTemplate() != null && renderer.getTemplate().getInterface() != null && null == renderer.getTemplate().getInterface().getJavaClass()) {
            renderer.getTemplate().getInterface().setJavaClass(renderer.getTargetClass());
        }
    }

    private void copyRendererAttributes(RendererModel renderer, ComponentModel component) {
        for (PropertyBase property : renderer.getAttributes()) {
            PropertyBase attribute = component.getOrCreateAttribute(property.getName());
            attribute.merge(property);
            this.verifyAttribute(attribute, (GeneratedFacesComponent)component);
        }
        renderer.setFamily(component.getFamily());
    }

    private boolean hasRendererSameBaseNameAsComponent(RendererModel renderer, ComponentModel component) {
        String componentBaseName = component.getTargetClass().getSimpleName();
        String rendererBaseName = renderer.getTargetClass().getSimpleName();
        componentBaseName = componentBaseName.replaceFirst("^UI", "");
        rendererBaseName = rendererBaseName.replaceFirst("Renderer$", "");
        return componentBaseName.equals(rendererBaseName);
    }

    protected void verifyComponents(ComponentLibrary library) throws CdkException {
        for (ComponentModel component : library.getComponents()) {
            try {
                this.verifyComponentType(component);
            }
            catch (RuntimeException e) {
                throw new CdkException("Caught error when verifying component " + component, (Throwable)e);
            }
        }
        HashSet verified = Sets.newHashSet();
        for (ComponentModel component : library.getComponents()) {
            try {
                this.verifyComponentType(component);
                this.verifyComponentAttributes(library, component, verified);
                if (null == component.getFamily()) {
                    component.setFamily(this.namingConventions.inferUIComponentFamily(component.getId()));
                }
                if (!component.getTags().isEmpty()) continue;
                TagModel tag = new TagModel();
                component.getTags().add((Object)tag);
                tag.setName(this.namingConventions.inferTagName(component.getId()));
                tag.setGenerate(false);
                tag.setType(TagType.Facelets);
            }
            catch (RuntimeException e) {
                throw new CdkException("Caught error when verifying component " + component, (Throwable)e);
            }
        }
    }

    protected void verifyComponentAttributes(ComponentLibrary library, ComponentModel component, Collection<ComponentModel> verified) {
        if (!verified.contains(component)) {
            verified.add(component);
            if (null != component.getBaseClass()) {
                try {
                    ComponentModel parentComponent = this.findParent((Iterable)library.getComponents(), (GeneratedFacesComponent)component);
                    component.setParent(parentComponent);
                    if (null == component.getFamily()) {
                        component.setFamily(parentComponent.getFamily());
                    }
                    this.verifyComponentAttributes(library, parentComponent, verified);
                    for (PropertyBase parentAttribute : parentComponent.getAttributes()) {
                        PropertyBase attribute = component.getOrCreateAttribute(parentAttribute.getName());
                        attribute.merge(parentAttribute);
                        attribute.setGenerate(Boolean.valueOf(false));
                    }
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
            for (PropertyBase attribute : component.getAttributes()) {
                this.verifyAttribute(attribute, (GeneratedFacesComponent)component);
            }
            for (TagModel tag : component.getTags()) {
                this.verifyTag(tag, component.getId(), DEFAULT_COMPONENT_HANDLER);
            }
            this.verifyDescription((DescriptionGroup)component);
            for (FacetModel facet : component.getFacets()) {
                this.verifyDescription((DescriptionGroup)facet);
            }
        }
    }

    private <T extends GeneratedFacesComponent> T findParent(Iterable<T> components, final T component) throws NoSuchElementException {
        return (T)((GeneratedFacesComponent)Iterables.find(components, (Predicate)new Predicate<T>(){

            public boolean apply(T input) {
                return component.getBaseClass().equals((Object)input.getTargetClass()) && component != input;
            }
        }));
    }

    protected void verifyTag(TagModel tag, FacesId id, ClassName handler) {
        if (Strings.isEmpty((String)tag.getName())) {
            String defaultTagName = this.namingConventions.inferTagName(id);
            tag.setName(defaultTagName);
        }
        if (null == tag.getType()) {
            tag.setType(TagType.Facelets);
        }
        if (tag.isGenerate()) {
            if (null == tag.getBaseClass()) {
                tag.setBaseClass(handler);
            }
            if (null == tag.getTargetClass()) {
                ClassName inferredTagHandler = this.namingConventions.inferTagHandlerClass(id, tag.getType().toString());
                tag.setTargetClass(inferredTagHandler);
            }
        }
    }

    protected void verifyComponentType(ComponentModel component) throws InvalidNameException {
        this.verifyTypes((GeneratedFacesComponent)component, new ComponentTypeCallback());
    }

    protected boolean verifyTypes(GeneratedFacesComponent component, NamingConventionsCallback callback) {
        try {
            if (null == component.getId()) {
                if (null != component.getTargetClass()) {
                    component.setId(callback.inferType(component.getTargetClass()));
                } else if (null != component.getBaseClass()) {
                    component.setId(callback.inferType(component.getBaseClass()));
                } else {
                    component.setId(callback.inferType());
                }
            }
            if (null == component.getGenerate()) {
                if (null == component.getTargetClass()) {
                    component.setTargetClass(callback.inferClass(component.getId()));
                }
                component.setGenerate(Boolean.valueOf(!((SourceUtils)this.sourceUtilsProvider.get()).isClassExists(component.getTargetClass())));
            }
            if (component.getGenerate().booleanValue()) {
                this.verifyGeneratedClasses(component, callback);
            } else if (null == component.getTargetClass()) {
                if (null == component.getBaseClass()) {
                    component.setBaseClass(callback.getDefaultClass());
                }
                component.setTargetClass(component.getBaseClass());
            }
        }
        catch (CallbackException e) {
            this.log.error((CharSequence)e.getMessage());
            return false;
        }
        return true;
    }

    private void verifyGeneratedClasses(GeneratedFacesComponent component, NamingConventionsCallback callback) throws CallbackException {
        if (null == component.getBaseClass()) {
            component.setBaseClass(callback.getDefaultBaseClass());
        }
        if (null == component.getTargetClass()) {
            component.setTargetClass(callback.inferClass(component.getId()));
        }
    }

    protected void verifyAttribute(PropertyBase attribute, GeneratedFacesComponent component) {
        if (Strings.isEmpty((String)attribute.getName())) {
            this.log.error((CharSequence)("No name for attribute " + attribute));
            return;
        }
        if (attribute.getName().contains(".") || Character.isDigit(attribute.getName().charAt(0)) || attribute.getName().contains(" ")) {
            this.log.error((CharSequence)("Invalid attribute name [" + attribute.getName() + "]"));
            return;
        }
        SourceUtils.BeanProperty beanProperty = this.findBeanProperty(attribute, component);
        if (null == attribute.getType()) {
            this.log.warn((CharSequence)("Unknown type of attribute [" + attribute.getName() + "]"));
            attribute.setType(beanProperty.getType());
        }
        if (attribute.getType().isPrimitive() && null == attribute.getDefaultValue()) {
            attribute.setDefaultValue(attribute.getType().getDefaultValue());
        }
        if ("javax.faces.el.MethodBinding".equals(attribute.getType().getName())) {
            attribute.setBinding(true);
            attribute.setBindingAttribute(true);
        } else if ("javax.el.MethodExpression".equals(attribute.getType().getName())) {
            attribute.setBindingAttribute(true);
        }
        if (Boolean.TRUE.equals(component.getGenerate())) {
            if (SPECIAL_PROPERTIES.contains((Object)attribute.getName())) {
                attribute.setGenerate(Boolean.valueOf(false));
            } else if (null == attribute.getGenerate()) {
                attribute.setGenerate(Boolean.valueOf(!beanProperty.isExists()));
            }
        } else {
            attribute.setGenerate(Boolean.valueOf(false));
        }
        this.verifyDescription((DescriptionGroup)attribute);
    }

    private SourceUtils.BeanProperty findBeanProperty(PropertyBase attribute, GeneratedFacesComponent component) {
        SourceUtils.BeanProperty beanProperty;
        block2: {
            ClassName interfaceName;
            ComponentModel model;
            SourceUtils sourceUtils = (SourceUtils)this.sourceUtilsProvider.get();
            beanProperty = sourceUtils.getBeanProperty(component.getBaseClass(), attribute.getName());
            if (beanProperty instanceof DummyPropertyImpl && component instanceof ComponentModel && null != (model = (ComponentModel)component).getParent()) {
                beanProperty = this.findBeanProperty(attribute, (GeneratedFacesComponent)model.getParent());
            }
            if (!(beanProperty instanceof DummyPropertyImpl) || !(component instanceof ModelElementBase)) break block2;
            model = (ModelElementBase)component;
            Iterator i$ = model.getInterfaces().iterator();
            while (i$.hasNext() && (beanProperty = sourceUtils.getBeanProperty(interfaceName = (ClassName)i$.next(), attribute.getName())) instanceof DummyPropertyImpl) {
            }
        }
        return beanProperty;
    }

    protected void verifyDescription(DescriptionGroup element) {
    }

    private final class RendererTypeCallback
    implements NamingConventionsCallback {
        private final ComponentLibrary library;
        private final RendererModel renderer;

        private RendererTypeCallback(ComponentLibrary library, RendererModel renderer) {
            this.library = library;
            this.renderer = renderer;
        }

        public FacesId inferType(ClassName targetClass) {
            try {
                return this.inferType();
            }
            catch (CallbackException e) {
                return RichFaces5Validator.this.namingConventions.inferRendererType(targetClass);
            }
        }

        public FacesId inferType() throws CallbackException {
            if (null != this.renderer.getTemplate()) {
                for (ComponentModel component : this.library.getComponents()) {
                    if (null == component.getRendererTemplate() || !this.renderer.getTemplate().getTemplatePath().endsWith(component.getRendererTemplate())) continue;
                    if (null != component.getRendererType()) {
                        return component.getRendererType();
                    }
                    FacesId rendererType = RichFaces5Validator.this.namingConventions.inferRendererType(component.getId());
                    component.setRendererType(rendererType);
                    return rendererType;
                }
                return RichFaces5Validator.this.namingConventions.inferRendererTypeByTemplatePath(this.renderer.getTemplate().getTemplatePath());
            }
            if (null != this.renderer.getFamily()) {
                return RichFaces5Validator.this.namingConventions.inferRendererType(this.renderer.getFamily());
            }
            throw new CallbackException("Cannot determine renderer type");
        }

        public ClassName inferClass(FacesId id) {
            return RichFaces5Validator.this.namingConventions.inferRendererClass(id);
        }

        public ClassName getDefaultClass() throws CallbackException {
            throw new CallbackException("Cannot determine renderer class name");
        }

        public ClassName getDefaultBaseClass() throws CallbackException {
            return ClassName.get(Renderer.class);
        }
    }

    private final class ValidatorTypeCallback
    implements NamingConventionsCallback {
        private final ValidatorModel validator;

        public ValidatorTypeCallback(ValidatorModel validator) {
            this.validator = validator;
        }

        public FacesId inferType(ClassName targetClass) throws CallbackException {
            return RichFaces5Validator.this.namingConventions.inferComponentType(targetClass);
        }

        public FacesId inferType() throws CallbackException {
            throw new CallbackException("Cannot infer type for validator " + this.validator);
        }

        public ClassName inferClass(FacesId id) throws CallbackException {
            throw new CallbackException("Cannot infer target Java class name for validator " + this.validator);
        }

        public ClassName getDefaultBaseClass() throws CallbackException {
            throw new CallbackException("Cannot infer default Java class name for validator " + this.validator);
        }

        public ClassName getDefaultClass() throws CallbackException {
            return ClassName.get(Object.class);
        }
    }

    private final class ConverterTypeCallback
    implements NamingConventionsCallback {
        private final ConverterModel converter;

        public ConverterTypeCallback(ConverterModel converter) {
            this.converter = converter;
        }

        public FacesId inferType(ClassName targetClass) throws CallbackException {
            return RichFaces5Validator.this.namingConventions.inferComponentType(targetClass);
        }

        public FacesId inferType() throws CallbackException {
            throw new CallbackException("Cannot infer type for converter " + this.converter);
        }

        public ClassName inferClass(FacesId id) throws CallbackException {
            throw new CallbackException("Cannot infer target Java class name for converter " + this.converter);
        }

        public ClassName getDefaultBaseClass() throws CallbackException {
            throw new CallbackException("Cannot infer base Java class name for converter " + this.converter);
        }

        public ClassName getDefaultClass() throws CallbackException {
            return ClassName.get(Object.class);
        }
    }

    private final class BehaviorTypeCallback
    implements NamingConventionsCallback {
        private final BehaviorModel behavior;

        private BehaviorTypeCallback(BehaviorModel behavior) {
            this.behavior = behavior;
        }

        public FacesId inferType(ClassName targetClass) {
            return RichFaces5Validator.this.namingConventions.inferBehaviorType(targetClass);
        }

        public FacesId inferType() throws CallbackException {
            throw new CallbackException("Cannot infer type for behavior " + this.behavior);
        }

        public ClassName inferClass(FacesId id) {
            return RichFaces5Validator.this.namingConventions.inferBehaviorClass(id);
        }

        public ClassName getDefaultBaseClass() throws CallbackException {
            return ClassName.get(ClientBehaviorBase.class);
        }

        public ClassName getDefaultClass() throws CallbackException {
            throw new CallbackException("Cannot infer Java class name for behavior " + this.behavior);
        }
    }

    private final class ComponentTypeCallback
    implements NamingConventionsCallback {
        private ComponentTypeCallback() {
        }

        public FacesId inferType(ClassName targetClass) {
            return RichFaces5Validator.this.namingConventions.inferComponentType(targetClass);
        }

        public ClassName inferClass(FacesId id) {
            return RichFaces5Validator.this.namingConventions.inferUIComponentClass(id);
        }

        public ClassName getDefaultBaseClass() throws CallbackException {
            return ClassName.get(UIComponentBase.class);
        }

        public ClassName getDefaultClass() throws CallbackException {
            throw new CallbackException("Cannot determine component class name");
        }

        public FacesId inferType() throws CallbackException {
            throw new CallbackException("Cannot determine component type");
        }
    }
}

