/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.shrinkwrap.descriptor;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.richfaces.shrinkwrap.descriptor.SimplifiedFormat;

public class FaceletAsset
implements Asset {
    private static final String TEMPLATE;
    private StringBuilder head = new StringBuilder();
    private StringBuilder body = new StringBuilder();
    private StringBuilder xmlns = new StringBuilder();
    private StringBuilder form = new StringBuilder();
    private boolean stateless = false;

    public FaceletAsset() {
        this.xmlns("ui", "http://java.sun.com/jsf/facelets");
        this.xmlns("h", "http://java.sun.com/jsf/html");
        this.xmlns("f", "http://java.sun.com/jsf/core");
        this.xmlns("c", "http://java.sun.com/jsp/jstl/core");
        this.xmlns("a4j", "http://richfaces.org/a4j");
        this.xmlns("rich", "http://richfaces.org/rich");
        this.xmlns("s", "http://richfaces.org/sandbox/prototyping");
        this.head("<style>body {background: white;}</style>");
    }

    public InputStream openStream() {
        return this.getAsStringAsset().openStream();
    }

    private StringAsset getAsStringAsset() {
        StringBuilder formFull = new StringBuilder(this.form);
        if (this.form.length() > 0) {
            formFull.insert(0, "        <h:form id='form' prependId='false'>");
            formFull.append("\n        </h:form>");
        }
        return new StringAsset(SimplifiedFormat.format(TEMPLATE, this.xmlns, this.head, this.body, formFull, this.stateless));
    }

    public FaceletAsset head(Object ... heads) {
        for (Object head : heads) {
            this.head.append(head);
            this.head.append('\n');
        }
        return this;
    }

    public FaceletAsset body(Object ... bodies) {
        for (Object body : bodies) {
            this.body.append(body);
            this.body.append('\n');
        }
        return this;
    }

    public FaceletAsset form(Object ... forms) {
        for (Object form : forms) {
            this.form.append(form);
            this.form.append('\n');
        }
        return this;
    }

    public FaceletAsset xmlns(String prefix, String uri) {
        this.xmlns.append("xmlns:" + prefix + "=\"" + uri + "\" \n");
        return this;
    }

    public FaceletAsset stateless(boolean stateless) {
        this.stateless = stateless;
        return this;
    }

    static {
        try {
            TEMPLATE = IOUtils.toString((InputStream)FaceletAsset.class.getResourceAsStream("facelet-template.xhtml"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

