/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.utils.focus;

import com.google.common.base.Predicate;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.richfaces.utils.focus.FocusRetriever;

public class ElementIsFocused
implements Predicate<WebDriver> {
    private WebElement element;

    public ElementIsFocused(WebElement element) {
        this.element = element;
    }

    public boolean apply(WebDriver browser) {
        try {
            if (this.element == null) {
                return FocusRetriever.retrieveActiveElement() == null;
            }
            return this.element.equals(FocusRetriever.retrieveActiveElement());
        }
        catch (StaleElementReferenceException e) {
            return false;
        }
    }

    public String toString() {
        WebElement activeElement = FocusRetriever.retrieveActiveElement();
        String focused = activeElement == null ? null : (activeElement.getAttribute("id") != null ? activeElement.getAttribute("id") : activeElement.toString());
        return String.format("waiting for the focus on '%s' failed - last focused element: %s", this.element, focused);
    }
}

