/**
 * 
 */
package org.richfaces.demo.extendedDataTable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.richfaces.component.html.HtmlExtendedDataTable;
import org.richfaces.demo.capitals.Capital;
import org.richfaces.model.selection.SimpleSelection;

/**
 * @author Ilya Shaikovsky
 * 
 */
public class ExtendedTableBean {
	private String sortMode="single";
	private String selectionMode="multi";
	private HtmlExtendedDataTable table;
	private SimpleSelection selection;
	private List<Capital> selectedCapitals = new ArrayList<Capital>();
	
	
	public void takeSelection() {
		getSelectedCapitals().clear();
		Iterator<Object> iterator = getSelection().getKeys();
		while (iterator.hasNext()){
			Object key = iterator.next();
			table.setRowKey(key);
			if (table.isRowAvailable()) {
				getSelectedCapitals().add((Capital) table.getRowData());
			}
		}
	} 
	
	public void resetSelection() {
		getSelectedCapitals().clear();
	}
	
	public String getSortMode() {
		return sortMode;
	}

	public void setSortMode(String sortMode) {
		this.sortMode = sortMode;
	}

	public String getSelectionMode() {
		return selectionMode;
	}

	public void setSelectionMode(String selectionMode) {
		this.selectionMode = selectionMode;
	}

	public ExtendedTableBean() {
	}

	public HtmlExtendedDataTable getTable() {
		return table;
	}

	public void setTable(HtmlExtendedDataTable table) {
		this.table = table;
	}

	public SimpleSelection getSelection() {
		return selection;
	}

	public void setSelection(SimpleSelection selection) {
		this.selection = selection;
	}

	public List<Capital> getSelectedCapitals() {
		return selectedCapitals;
	}

	public void setSelectedCapitals(List<Capital> selectedCapitals) {
		this.selectedCapitals = selectedCapitals;
	}
	
}
