/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.richfaces.Organism;
import org.richfaces.Pathway;
import org.richfaces.model.TreeNode;

public class Library
implements TreeNode {
    private Map pathways = null;
    private Object state1;
    private List listPathway;
    private long nextId = 0L;
    private Map pathCache = new HashMap();

    public Library() {
    }

    public Library(List l) {
        this.listPathway = l;
    }

    private Map getPathways() {
        if (this.pathways == null) {
            this.initData();
        }
        return this.pathways;
    }

    public void addPathway(Pathway pw) {
        this.addChild((Object)Long.toString(pw.getId()), (TreeNode)pw);
        pw.setParent((TreeNode)this);
    }

    public void addChild(Object identifier, TreeNode child) {
        this.getPathways().put(identifier, child);
    }

    public TreeNode getChild(Object id) {
        return (TreeNode)this.getPathways().get(id);
    }

    public Iterator getChildren() {
        return this.getPathways().entrySet().iterator();
    }

    public Object getData() {
        return this;
    }

    public TreeNode getParent() {
        return null;
    }

    public boolean isLeaf() {
        return this.getPathways().isEmpty();
    }

    public void removeChild(Object id) {
        this.getPathways().remove(id);
    }

    public void setData(Object data) {
    }

    public void setParent(TreeNode parent) {
    }

    public String getType() {
        return "library";
    }

    private long getNextId() {
        return this.nextId++;
    }

    private Pathway getPathwayByName(String name, Library library) {
        Pathway pathway = (Pathway)this.pathCache.get(name);
        if (pathway == null) {
            pathway = new Pathway(this.getNextId());
            pathway.setName(name);
            this.pathCache.put(name, pathway);
            library.addPathway(pathway);
        }
        return pathway;
    }

    private void initData() {
        this.pathways = new HashMap();
        for (int i = 0; i < 50; ++i) {
            Pathway path = this.getPathwayByName("PATH_" + i, this);
            for (int j = 0; j < 50; ++j) {
                Organism org = new Organism(this.getNextId());
                org.setName("ORG_" + i + "." + j);
                path.addOrganism(org);
            }
        }
    }

    public Object getState1() {
        return this.state1;
    }

    public void setState1(Object state1) {
        this.state1 = state1;
    }
}

