/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.richfaces.Library;
import org.richfaces.Organism;
import org.richfaces.model.TreeNode;

public class Pathway
implements TreeNode {
    private long id;
    private Map organisms = new HashMap();
    private String name;
    private Library library;

    public Pathway(long id) {
        this.id = id;
    }

    public void addOrganism(Organism org) {
        this.addChild((Object)Long.toString(org.getId()), (TreeNode)org);
        org.setParent((TreeNode)this);
    }

    public void addChild(Object identifier, TreeNode child) {
        this.organisms.put(identifier, child);
    }

    public TreeNode getChild(Object id) {
        return (TreeNode)this.organisms.get(id);
    }

    public Iterator getChildren() {
        return this.organisms.entrySet().iterator();
    }

    public Object getData() {
        return this;
    }

    public TreeNode getParent() {
        return this.library;
    }

    public boolean isLeaf() {
        return this.organisms.isEmpty();
    }

    public void removeChild(Object id) {
        this.organisms.remove(id);
    }

    public void setData(Object data) {
    }

    public void setParent(TreeNode parent) {
        this.library = (Library)parent;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Library getLibrary() {
        return this.library;
    }

    public void setLibrary(Library library) {
        this.library = library;
    }

    public String getType() {
        return "pathway";
    }
}

