<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>

<%@ taglib uri="http://labs.jboss.com/jbossrichfaces/ui/treeModel" prefix="model" %>
<%@ taglib uri="http://labs.jboss.com/jbossrichfaces/ui/tree" prefix="tree" %>

<html>
	<head>
		<title></title>
	</head>
	<body>
		<f:view>
			<h:form>
				<tree:tree adviseNodeOpened="#{treeModelBean.adviseNodeOpened}" switchType="client">
					<model:treeNodesAdaptor id="project" nodes="#{loaderBean.projects}" var="project">
						<tree:treeNode>
					    	<h:commandLink action="#{project.click}" value="Project: #{project.name}" />
					    </tree:treeNode>
	
						<model:treeNodesAdaptor id="srcDir" var="srcDir" nodes="#{project.srcDirs}">
							<tree:treeNode>
								<h:commandLink action="#{srcDir.click}" value="Source directory: #{srcDir.name}" />
							</tree:treeNode>
	
							<model:treeNodesAdaptor id="pkg" var="pkg" nodes="#{srcDir.packages}">
								<tree:treeNode>
									<h:commandLink action="#{pkg.click}" value="Package: #{pkg.name}" />
								</tree:treeNode>
	
								<model:treeNodesAdaptor id="class" var="class" nodes="#{pkg.classes}">
									<tree:treeNode>
										<h:commandLink action="#{class.click}" value="Class: #{class.name}" />
									</tree:treeNode>
								</model:treeNodesAdaptor>
							</model:treeNodesAdaptor>

							<model:treeNodesAdaptor id="pkg1" var="pkg" nodes="#{srcDir.packages}">
								<tree:treeNode>
									<h:commandLink action="#{pkg.click}" value="Package1: #{pkg.name}" />
								</tree:treeNode>
	
								<model:treeNodesAdaptor id="class1" var="class" nodes="#{pkg.classes}">
									<tree:treeNode>
										<h:commandLink action="#{class.click}" value="Class1: #{class.name}" />
									</tree:treeNode>
								</model:treeNodesAdaptor>
							</model:treeNodesAdaptor>
						</model:treeNodesAdaptor>
						
						<model:recursiveTreeNodesAdaptor id="dir" var="dir"
							roots="#{project.dirs}" nodes="#{dir.directories}">
							<tree:treeNode>
								<h:commandLink action="#{dir.click}" value="Directory: #{dir.name}" />
							</tree:treeNode>
							
							<model:treeNodesAdaptor id="file" var="file" nodes="#{dir.files}">
								<tree:treeNode>
									<h:commandLink action="#{file.click}" value="File: #{file.name}" />
								</tree:treeNode>
							</model:treeNodesAdaptor>
							
							<model:treeNodesAdaptor id="file1" var="file" nodes="#{dir.files}">
								<tree:treeNode>
									<h:commandLink action="#{file.click}" value="File1: #{file.name}" />
								</tree:treeNode>
							</model:treeNodesAdaptor>

							<model:recursiveTreeNodesAdaptor id="archiveEntry" var="archiveEntry"
								roots="#{dir.files}" nodes="#{archiveEntry.archiveEntries}" 
								includedRoot="#{archiveEntry.class.simpleName == 'ArchiveFile'}"
								includedNode="#{archiveEntry.class.simpleName == 'ArchiveEntry'}">
							
								<tree:treeNode id="archiveEntryNode">
									<h:commandLink action="#{archiveEntry.click}" value="Archive entry: #{archiveEntry.name}" />
								</tree:treeNode>

							</model:recursiveTreeNodesAdaptor>

						</model:recursiveTreeNodesAdaptor>
	
						<%--model:treeNodes var="file" nodes="#{proj.dir.files}">
							<tree:treeNode>
								<h:outputText value="File: #{file.name}" />
							</tree:treeNode>
						</model:treeNodes--%>
					</model:treeNodesAdaptor>
				</tree:tree>
			</h:form>
		</f:view>
	</body>	
</html>  
