/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractDragSource;

/**
 *  @author abelevich


 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIDragSource extends AbstractDragSource
        {

    public static final String COMPONENT_TYPE="org.richfaces.DragSource";

    public static final String COMPONENT_FAMILY="org.richfaces.DragSource";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIDragSource() {
        super();
        setRendererType("org.richfaces.DragSourceRenderer");
    }



    protected static enum Properties {
        ajaxSingle,
        bypassUpdates,
        data,
        dragIndicator,
        dragValue,
        eventsQueue,
        focus,
        ignoreDupResponses,
        limitRender,
        onbeforedomupdate,
        onbegin,
        oncomplete,
        process,
        reRender,
        requestDelay,
        similarityGroupingId,
        status,
        timeout,
        type

    }


 
    public boolean isAjaxSingle() {
        return (Boolean) getStateHelper().eval(Properties.ajaxSingle, false);
    }
    
    public void setAjaxSingle(boolean ajaxSingle) {
        getStateHelper().put(Properties.ajaxSingle, ajaxSingle);
    }

 
    public boolean isBypassUpdates() {
        return (Boolean) getStateHelper().eval(Properties.bypassUpdates, false);
    }
    
    public void setBypassUpdates(boolean bypassUpdates) {
        getStateHelper().put(Properties.bypassUpdates, bypassUpdates);
    }

 
    public Object getData() {
        return (Object) getStateHelper().eval(Properties.data);
    }
    
    public void setData(Object data) {
        getStateHelper().put(Properties.data, data);
    }

 
    public String getDragIndicator() {
        return (String) getStateHelper().eval(Properties.dragIndicator);
    }
    
    public void setDragIndicator(String dragIndicator) {
        getStateHelper().put(Properties.dragIndicator, dragIndicator);
    }

 
    public Object getDragValue() {
        return (Object) getStateHelper().eval(Properties.dragValue);
    }
    
    public void setDragValue(Object dragValue) {
        getStateHelper().put(Properties.dragValue, dragValue);
    }

 
    public String getEventsQueue() {
        return (String) getStateHelper().eval(Properties.eventsQueue);
    }
    
    public void setEventsQueue(String eventsQueue) {
        getStateHelper().put(Properties.eventsQueue, eventsQueue);
    }

 
    public String getFocus() {
        return (String) getStateHelper().eval(Properties.focus);
    }
    
    public void setFocus(String focus) {
        getStateHelper().put(Properties.focus, focus);
    }

 
    public boolean isIgnoreDupResponses() {
        return (Boolean) getStateHelper().eval(Properties.ignoreDupResponses, false);
    }
    
    public void setIgnoreDupResponses(boolean ignoreDupResponses) {
        getStateHelper().put(Properties.ignoreDupResponses, ignoreDupResponses);
    }

 
    public boolean isLimitRender() {
        return (Boolean) getStateHelper().eval(Properties.limitRender, false);
    }
    
    public void setLimitRender(boolean limitRender) {
        getStateHelper().put(Properties.limitRender, limitRender);
    }

 
    public String getOnbeforedomupdate() {
        return (String) getStateHelper().eval(Properties.onbeforedomupdate);
    }
    
    public void setOnbeforedomupdate(String onbeforedomupdate) {
        getStateHelper().put(Properties.onbeforedomupdate, onbeforedomupdate);
    }

 
    public String getOnbegin() {
        return (String) getStateHelper().eval(Properties.onbegin);
    }
    
    public void setOnbegin(String onbegin) {
        getStateHelper().put(Properties.onbegin, onbegin);
    }

 
    public String getOncomplete() {
        return (String) getStateHelper().eval(Properties.oncomplete);
    }
    
    public void setOncomplete(String oncomplete) {
        getStateHelper().put(Properties.oncomplete, oncomplete);
    }

 
    public Object getProcess() {
        return (Object) getStateHelper().eval(Properties.process);
    }
    
    public void setProcess(Object process) {
        getStateHelper().put(Properties.process, process);
    }

 
    public Object getReRender() {
        return (Object) getStateHelper().eval(Properties.reRender);
    }
    
    public void setReRender(Object reRender) {
        getStateHelper().put(Properties.reRender, reRender);
    }

 
    public int getRequestDelay() {
        return (Integer) getStateHelper().eval(Properties.requestDelay, Integer.MIN_VALUE);
    }
    
    public void setRequestDelay(int requestDelay) {
        getStateHelper().put(Properties.requestDelay, requestDelay);
    }

 
    public String getSimilarityGroupingId() {
        return (String) getStateHelper().eval(Properties.similarityGroupingId);
    }
    
    public void setSimilarityGroupingId(String similarityGroupingId) {
        getStateHelper().put(Properties.similarityGroupingId, similarityGroupingId);
    }

 
    public String getStatus() {
        return (String) getStateHelper().eval(Properties.status);
    }
    
    public void setStatus(String status) {
        getStateHelper().put(Properties.status, status);
    }

 
    public int getTimeout() {
        return (Integer) getStateHelper().eval(Properties.timeout, Integer.MIN_VALUE);
    }
    
    public void setTimeout(int timeout) {
        getStateHelper().put(Properties.timeout, timeout);
    }

 
    public String getType() {
        return (String) getStateHelper().eval(Properties.type);
    }
    
    public void setType(String type) {
        getStateHelper().put(Properties.type, type);
    }

}