/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractDropTarget;

/**
 *  @author abelevich


 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIDropTarget extends AbstractDropTarget
        {

    public static final String COMPONENT_TYPE="org.richfaces.DropTarget";

    public static final String COMPONENT_FAMILY="org.richfaces.DropTarget";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIDropTarget() {
        super();
        setRendererType("org.richfaces.DropTargetRenderer");
    }



    protected static enum Properties {
        acceptedTypes,
        bypassUpdates,
        dropValue

    }


 
    public Object getAcceptedTypes() {
        return (Object) getStateHelper().eval(Properties.acceptedTypes);
    }
    
    public void setAcceptedTypes(Object acceptedTypes) {
        getStateHelper().put(Properties.acceptedTypes, acceptedTypes);
    }

 
    public boolean isBypassUpdates() {
        return (Boolean) getStateHelper().eval(Properties.bypassUpdates, false);
    }
    
    public void setBypassUpdates(boolean bypassUpdates) {
        getStateHelper().put(Properties.bypassUpdates, bypassUpdates);
    }

 
    public Object getDropValue() {
        return (Object) getStateHelper().eval(Properties.dropValue);
    }
    
    public void setDropValue(Object dropValue) {
        getStateHelper().put(Properties.dropValue, dropValue);
    }

}